/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.world.spawner;

import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.entity.EntityInit;
import com.lgow.endofherobrine.entity.herobrine.AbstractHerobrine;
import com.lgow.endofherobrine.event.WrathHandler;
import com.lgow.endofherobrine.util.ModUtil;
import com.lgow.endofherobrine.world.data.ModSavedData;
import com.lgow.endofherobrine.world.spawner.SpawnerData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;

public class HerobrineSpawner {
    private final SpawnerData data;
    private final RandomSource random = RandomSource.m_216327_();
    private int tickDelay;
    private int currentSpawnDelay;
    private int currentSpawnChance;
    private final int spawnCooldown;
    private final int spawnChance;

    public HerobrineSpawner(MinecraftServer server, String key) {
        this.data = ModSavedData.get(server).getSpawnerData(key);
        this.tickDelay = 600;
        this.currentSpawnDelay = this.data.getSpawnDelay();
        this.currentSpawnChance = this.data.getSpawnChance();
        this.spawnCooldown = ConfigHandler.getSpawnCooldown();
        this.spawnChance = ConfigHandler.getSpawnChance();
        if (this.currentSpawnDelay == 0 && this.currentSpawnChance == 0) {
            this.currentSpawnDelay = this.spawnCooldown;
            this.currentSpawnChance = this.spawnChance;
            this.data.setSpawnDelay(this.currentSpawnDelay);
            this.data.setSpawnChance(this.currentSpawnChance);
        }
    }

    public void tick(ServerLevel level) {
        if (this.spawnChance != 0 && WrathHandler.getHerobrinesWrath(level) > 0 && !ModUtil.herobrineExists((Level)level) && --this.tickDelay <= 0) {
            int delay;
            this.tickDelay = delay = Math.max(this.spawnCooldown / 20, 1);
            this.currentSpawnDelay -= delay;
            this.data.setSpawnDelay(this.currentSpawnDelay);
            if (this.currentSpawnDelay <= 0) {
                this.currentSpawnDelay = this.spawnCooldown;
                if (level.m_46469_().m_46207_(GameRules.f_46134_)) {
                    int spawnChance = this.currentSpawnChance;
                    this.currentSpawnChance = Mth.m_14045_((int)(this.currentSpawnChance + this.spawnChance), (int)this.spawnChance, (int)100);
                    this.data.setSpawnChance(this.currentSpawnChance);
                    if (level.m_213780_().m_188503_(100) <= spawnChance && this.spawnVariant(level)) {
                        this.currentSpawnChance = this.spawnChance;
                    }
                }
            }
        }
    }

    private boolean spawnVariant(ServerLevel level) {
        List players = level.m_6907_();
        if (players.isEmpty()) {
            return false;
        }
        Player randomPlayer = (Player)players.get(level.m_213780_().m_188503_(players.size()));
        if (randomPlayer == null) {
            return true;
        }
        BlockPos blockPos = this.findPositionAroundPlayer((LevelReader)randomPlayer.m_9236_(), randomPlayer.m_20097_(), 48);
        AbstractHerobrine herobrine = null;
        if (blockPos != null && this.hasEnoughSpace((BlockGetter)level, blockPos)) {
            if (this.random.m_188503_(7) != 0) {
                herobrine = (AbstractHerobrine)((EntityType)EntityInit.LURKER.get()).m_262496_(level, blockPos, MobSpawnType.EVENT);
            } else if (ConfigHandler.shouldSpawnBuilder()) {
                herobrine = (AbstractHerobrine)((EntityType)EntityInit.BUILDER.get()).m_262496_(level, blockPos, MobSpawnType.EVENT);
            }
            return herobrine != null;
        }
        return false;
    }

    @Nullable
    private BlockPos findPositionAroundPlayer(LevelReader pLevel, BlockPos pPos, int pMaxDistance) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pPos.m_123341_() + this.random.m_188503_(pMaxDistance * 2) - pMaxDistance;
            BlockPos blockpos1 = new BlockPos(j, l = pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = pPos.m_123343_() + this.random.m_188503_(pMaxDistance * 2) - pMaxDistance), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)pLevel, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(BlockGetter pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos, (BlockPos)pPos.m_7918_(1, 2, 1))) {
            if (pLevel.m_8055_(blockpos).m_60812_(pLevel, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

