/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.world.spawner;

import com.lgow.endofherobrine.world.spawner.HerobrineSpawner;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endofherobrine")
public class SpawnEvents {
    private static final Map<ResourceLocation, HerobrineSpawner> spawners = new HashMap<ResourceLocation, HerobrineSpawner>();

    @SubscribeEvent
    public static void onWorldLoad(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        spawners.put(BuiltinDimensionTypes.f_223538_.m_135782_(), new HerobrineSpawner(server, "herobrineOverworld"));
        spawners.put(BuiltinDimensionTypes.f_223539_.m_135782_(), new HerobrineSpawner(server, "herobrineNether"));
    }

    @SubscribeEvent
    public static void onServerStart(ServerStoppedEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        HerobrineSpawner spawner = spawners.get(event.level.m_46472_().m_135782_());
        if (spawner != null) {
            spawner.tick((ServerLevel)event.level);
        }
    }

    public static void register() {
    }
}

