/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.data.filter.Filters;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ViewfinderShader {
    @Nullable
    private static ResourceLocation previousShader;

    public static Optional<ResourceLocation> getCurrent() {
        PostChain effect = Minecraft.m_91087_().f_91063_.m_109149_();
        if (effect != null) {
            return Optional.of(new ResourceLocation(effect.m_110022_()));
        }
        return Optional.empty();
    }

    public static void setPrevious(@Nullable ResourceLocation shader) {
        previousShader = shader;
    }

    public static void restorePrevious() {
        if (previousShader != null && ViewfinderShader.shouldRestorePreviousShaderEffect()) {
            ViewfinderShader.applyShader(previousShader);
            previousShader = null;
        }
    }

    public static void applyShader(ResourceLocation shader) {
        @Nullable PostChain effect = Minecraft.m_91087_().f_91063_.m_109149_();
        if (effect != null && effect.m_110022_().equals(shader.toString())) {
            return;
        }
        Minecraft.m_91087_().f_91063_.m_109128_(shader);
    }

    public static void removeShader() {
        Minecraft.m_91087_().f_91063_.m_109086_();
    }

    public static void update() {
        Optional<Camera<?>> camera = Camera.getCamera((Player)Minecraft.m_91087_().f_91074_);
        if (camera.isEmpty()) {
            ViewfinderShader.removeShader();
            return;
        }
        ItemAndStack<?> cameraItemAndStack = camera.get().get();
        ((CameraItem)((Object)cameraItemAndStack.getItem())).getAttachment(cameraItemAndStack.getStack(), CameraItem.FILTER_ATTACHMENT).flatMap(Filters::getShaderOf).ifPresentOrElse(ViewfinderShader::applyShader, ViewfinderShader::removeShader);
    }

    public static boolean shouldRestorePreviousShaderEffect() {
        if (PlatformHelper.isModLoaded("cold_sweat") && previousShader != null && previousShader.toString().equals("minecraft:shaders/post/blobs2.json")) {
            return false;
        }
        return previousShader != null;
    }
}

