/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.data;

import io.github.mortuusars.exposure.render.image.IImage;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.MapColor;

public class ExposureThumbnail
implements IImage {
    private final String id;
    protected int width;
    protected int height;
    protected byte[] pixels;

    public ExposureThumbnail(String id, int width, int height, byte[] pixels) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
    }

    public String getImageId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPixels() {
        return this.pixels;
    }

    public byte getPixel(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public int getPixelABGR(int x, int y) {
        return MapColor.m_284315_((int)this.getPixel(x, y));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExposureThumbnail thumbnail = (ExposureThumbnail)o;
        return this.width == thumbnail.width && this.height == thumbnail.height && Arrays.equals(this.pixels, thumbnail.pixels);
    }

    public int hashCode() {
        int result = Objects.hash(this.width, this.height);
        result = 31 * result + Arrays.hashCode(this.pixels);
        return result;
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.id);
        buffer.writeInt(this.width);
        buffer.writeInt(this.height);
        buffer.m_130087_(this.pixels);
    }

    public static ExposureThumbnail fromBuffer(FriendlyByteBuf buffer) {
        return new ExposureThumbnail(buffer.m_130277_(), buffer.readInt(), buffer.readInt(), buffer.m_130052_());
    }
}

