/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import umpaz.farmersrespite.common.block.entity.container.KettleMenu;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
public class KettleScreen
extends AbstractContainerScreen<KettleMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("farmersrespite", "textures/gui/kettle.png");
    private static final Rectangle HEAT_ICON = new Rectangle(41, 55, 17, 15);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(62, 25, 0, 17);

    public KettleScreen(KettleMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97728_ = 28;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.renderTankTooltip(gui, mouseX, mouseY);
        this.m_280072_(gui, mouseX, mouseY);
        this.renderHeatIndicatorTooltip(gui, mouseX, mouseY);
    }

    private void renderTankTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.m_6774_(106, 18, 37, 28, mouseX, mouseY) && !((KettleMenu)this.f_97732_).kettleTank.isEmpty()) {
            MutableComponent component = MutableComponent.m_237204_((ComponentContents)((KettleMenu)this.f_97732_).kettleTank.getFluid().getDisplayName().m_214077_()).m_130946_(" (%s/%s mB)".formatted(((KettleMenu)this.f_97732_).kettleTank.getFluidAmount(), ((KettleMenu)this.f_97732_).kettleTank.getCapacity()));
            gui.m_280557_(this.f_96547_, (Component)component, mouseX, mouseY);
        }
    }

    private void renderHeatIndicatorTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.m_6774_(KettleScreen.HEAT_ICON.x, KettleScreen.HEAT_ICON.y, KettleScreen.HEAT_ICON.width, KettleScreen.HEAT_ICON.height, mouseX, mouseY)) {
            String key = "container.cooking_pot." + (((KettleMenu)this.f_97732_).isHeated() ? "heated" : "not_heated");
            Tooltip tooltip = Tooltip.m_257550_((Component)TextUtils.getTranslation((String)key, (Object[])new Object[]{this.f_97732_}));
            this.m_262791_(tooltip, DefaultTooltipPositioner.f_262752_, true);
        }
    }

    private void renderWaterBarIndicatorTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.m_6774_(35, 18, 3, 31, mouseX, mouseY)) {
            Component key = null;
            Tooltip tooltip = Tooltip.m_257550_(key);
            this.m_262791_(tooltip, DefaultTooltipPositioner.f_262752_, true);
        }
    }

    protected void m_280003_(GuiGraphics gui, int mouseX, int mouseY) {
        super.m_280003_(gui, mouseX, mouseY);
        gui.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        int y2;
        int y1;
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((KettleMenu)this.f_97732_).isHeated()) {
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + KettleScreen.HEAT_ICON.x, this.f_97736_ + KettleScreen.HEAT_ICON.y, 176, 0, KettleScreen.HEAT_ICON.width, KettleScreen.HEAT_ICON.height);
        }
        int l = ((KettleMenu)this.f_97732_).getBrewProgressionScaled();
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + KettleScreen.PROGRESS_ARROW.x, this.f_97736_ + KettleScreen.PROGRESS_ARROW.y, 176, 15, l + 1, KettleScreen.PROGRESS_ARROW.height);
        FluidStack fluidStack = ((KettleMenu)this.f_97732_).kettleTank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.f_96541_.m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(fluidStack);
        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(tintColor & 0xFF) / 255.0f;
        float capacity = (float)((KettleMenu)this.f_97732_).kettleTank.getFluidAmount() / (float)((KettleMenu)this.f_97732_).kettleTank.getCapacity();
        if ((double)capacity > 0.57) {
            y1 = this.f_97736_ + 18 + (int)(12.0f * (1.0f - (capacity - 0.57f) / 0.43f));
            y2 = this.f_97736_ + 18 + 12;
            float topCapacity = (capacity - 0.57f) / 0.43f;
            float vDistance = sprite.m_118412_() - sprite.m_118411_();
            float v0 = sprite.m_118411_() + 0.25f * vDistance + 0.75f * vDistance * (1.0f - topCapacity);
            gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 105, this.f_97735_ + 105 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
            gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 121, this.f_97735_ + 121 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
            gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 137, this.f_97735_ + 137 + 7, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
        }
        y1 = this.f_97736_ + 30 + (int)(16.0f * (1.0f - Math.min(1.0f, capacity / 0.57f)));
        y2 = this.f_97736_ + 30 + 16;
        float vDistance = sprite.m_118412_() - sprite.m_118411_();
        float v0 = sprite.m_118411_() + vDistance * (1.0f - Math.min(1.0f, capacity / 0.57f));
        gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 105, this.f_97735_ + 105 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
        gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 121, this.f_97735_ + 121 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
        gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 137, this.f_97735_ + 137 + 7, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 105, this.f_97736_ + 17, 176, 32, 40, 34);
    }
}

