/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeSerializers;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;

public class KettleRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 2;
    private final ResourceLocation id;
    private final NonNullList<Ingredient> inputItems;
    private final FluidStack fluidIn;
    private final FluidStack fluidOut;
    private final float experience;
    private final int brewTime;

    public KettleRecipe(ResourceLocation id, NonNullList<Ingredient> inputItems, FluidStack fluidIn, FluidStack fluidOut, float experience, int brewTime) {
        this.id = id;
        this.inputItems = inputItems;
        this.fluidIn = fluidIn;
        this.fluidOut = fluidOut;
        this.experience = experience;
        this.brewTime = brewTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public FluidStack getFluidIn() {
        return this.fluidIn;
    }

    public FluidStack getFluidOut() {
        return this.fluidOut;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack assemble(RecipeWrapper inv, RegistryAccess access) {
        return null;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FRRecipeSerializers.BREWING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FRRecipeTypes.BREWING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)FRItems.KETTLE.get());
    }

    public static class Serializer
    implements RecipeSerializer<KettleRecipe> {
        public KettleRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for brewing recipe");
            }
            if (inputItemsIn.size() > 2) {
                throw new JsonParseException("Too many ingredients for brewing recipe! The max is 2");
            }
            JsonObject baseFluid = json.getAsJsonObject("base");
            if (baseFluid == null) {
                throw new JsonParseException("No base fluid for brewing recipe");
            }
            String fluid = GsonHelper.m_13906_((JsonObject)baseFluid, (String)"fluid");
            Fluid fluidObj = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid));
            if (fluidObj == null) {
                throw new JsonParseException("Invalid fluid: " + fluid);
            }
            FluidStack fluidIn = new FluidStack(fluidObj, GsonHelper.m_13824_((JsonObject)baseFluid, (String)"count", (int)200));
            JsonObject resultFluid = json.getAsJsonObject("result");
            if (resultFluid == null) {
                throw new JsonParseException("No result fluid for brewing recipe");
            }
            fluid = GsonHelper.m_13906_((JsonObject)resultFluid, (String)"fluid");
            fluidObj = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid));
            if (fluidObj == null) {
                throw new JsonParseException("Invalid fluid: " + fluid);
            }
            FluidStack fluidOut = new FluidStack(fluidObj, GsonHelper.m_13824_((JsonObject)resultFluid, (String)"count", (int)200));
            float experienceIn = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int brewTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"brewingtime", (int)200);
            return new KettleRecipe(recipeId, inputItemsIn, fluidIn, fluidOut, experienceIn, brewTimeIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public KettleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            FluidStack fluidIn = buffer.readFluidStack();
            FluidStack fluidOut = buffer.readFluidStack();
            float experienceIn = buffer.readFloat();
            int brewTimeIn = buffer.m_130242_();
            return new KettleRecipe(recipeId, (NonNullList<Ingredient>)inputItemsIn, fluidIn, fluidOut, experienceIn, brewTimeIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, KettleRecipe recipe) {
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeFluidStack(recipe.fluidIn);
            buffer.writeFluidStack(recipe.fluidOut);
            buffer.writeFloat(recipe.experience);
            buffer.m_130130_(recipe.brewTime);
        }
    }
}

