/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.TestingTools;
import mcjty.incontrol.tools.varia.LookAtTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class TestingBlockTools {
    private static boolean testBlockStateSafe(LevelAccessor world, BlockPos pos, Block block) {
        LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk != null) {
            BlockState state = world.m_8055_(pos);
            return state.m_60734_() == block;
        }
        return false;
    }

    private static boolean testBlockStateSafe(LevelAccessor world, BlockPos pos, BlockState block) {
        LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk != null) {
            BlockState state = world.m_8055_(pos);
            return state == block;
        }
        return false;
    }

    @Nullable
    public static BiPredicate<LevelAccessor, BlockPos> parseBlock(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        return TestingBlockTools.parseBlockJson(element);
    }

    @Nullable
    public static BiPredicate<LevelAccessor, BlockPos> parseBlockJson(JsonElement element) {
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            if (blockname.startsWith("tag:")) {
                ResourceLocation tagname = new ResourceLocation(blockname.substring(4));
                TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagname);
                return (world, pos) -> {
                    BlockState state = world.m_8055_(pos);
                    return state.m_204336_(key);
                };
            }
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockname))) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return null;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            return (world, pos) -> TestingBlockTools.testBlockStateSafe(world, pos, block);
        }
        if (element.isJsonObject()) {
            BiPredicate<LevelAccessor, BlockPos> finalTest;
            Predicate<Integer> energy;
            BiPredicate<LevelAccessor, BlockPos> test;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("tag")) {
                ResourceLocation tagname = new ResourceLocation(obj.get("tag").getAsString());
                TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagname);
                test = (world, pos) -> {
                    BlockState state = world.m_8055_(pos);
                    return state.m_204336_(key);
                };
            } else if (obj.has("block")) {
                String blockname = obj.get("block").getAsString();
                if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockname))) {
                    ErrorHandler.error("Block '" + blockname + "' is not valid!");
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
                if (obj.has("properties")) {
                    BlockState blockState = block.m_49966_();
                    JsonArray propArray = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : propArray) {
                        JsonObject propObj = el.getAsJsonObject();
                        String name = propObj.get("name").getAsString();
                        String value = propObj.get("value").getAsString();
                        for (Property key : blockState.m_61147_()) {
                            if (!name.equals(key.m_61708_())) continue;
                            blockState = TestingTools.set(blockState, key, value);
                        }
                    }
                    BlockState finalBlockState = blockState;
                    test = (world, pos) -> TestingBlockTools.testBlockStateSafe(world, pos, finalBlockState);
                } else {
                    test = (world, pos) -> TestingBlockTools.testBlockStateSafe(world, pos, block);
                }
            } else {
                test = (world, pos) -> true;
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                BiPredicate<LevelAccessor, BlockPos> finalTest2 = test;
                test = (world, pos) -> {
                    LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                    if (chunk != null) {
                        return finalTest2.test((LevelAccessor)world, (BlockPos)pos) && mod.equals(ForgeRegistries.BLOCKS.getKey((Object)world.m_8055_(pos).m_60734_()).m_135827_());
                    }
                    return false;
                };
            }
            if (obj.has("energy") && (energy = TestingTools.getExpression(obj.get("energy"))) != null) {
                Direction side = obj.has("side") ? Direction.m_122402_((String)obj.get("side").getAsString().toLowerCase()) : null;
                finalTest = test;
                test = (world, pos) -> finalTest.test((LevelAccessor)world, (BlockPos)pos) && energy.test(TestingTools.getEnergy(world, pos, side));
            }
            if (obj.has("contains")) {
                Direction side = obj.has("side") ? Direction.m_122402_((String)obj.get("energyside").getAsString().toLowerCase()) : null;
                List<Predicate<ItemStack>> items = TestingTools.getItemsJson(obj.get("contains"));
                finalTest = test;
                test = (world, pos) -> finalTest.test((LevelAccessor)world, (BlockPos)pos) && TestingTools.contains(world, pos, side, items);
            }
            return test;
        }
        ErrorHandler.error("Block description is not valid!");
        return null;
    }

    @Nonnull
    public static BiFunction<Object, IEventQuery, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = obj.has("x") ? obj.get("x").getAsInt() : 0;
            offsetY = obj.has("y") ? obj.get("y").getAsInt() : 0;
            int n = offsetZ = obj.has("z") ? obj.get("z").getAsInt() : 0;
        }
        if (obj.has("look")) {
            return (event, query) -> {
                HitResult result = LookAtTools.getMovingObjectPositionFromPlayer(query.getWorld(event), query.getPlayer(event), false);
                if (result instanceof BlockHitResult) {
                    return ((BlockHitResult)result).m_82425_().m_7918_(offsetX, offsetY, offsetZ);
                }
                return query.getValidBlockPos(event).m_7918_(offsetX, offsetY, offsetZ);
            };
        }
        return (event, query) -> query.getValidBlockPos(event).m_7918_(offsetX, offsetY, offsetZ);
    }
}

