#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;
in vec4 normal;

out vec4 fragColor;

#define EQ(a,b) (abs(a - b) < 0.002)

void main() {
   vec4 texColor = texture(Sampler0, texCoord0);
   vec4 color = texColor * vertexColor * ColorModulator;

   if (color.a < 0.1) {
      discard;
   }

   color = EQ(color.a, 254.0/255.0) ? texColor : color;
   fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
