/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.client.widget.TooltipImageButton;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public class PropertyImageButton<T extends StringRepresentable>
extends TooltipImageButton {
    protected final Component name;
    protected final ToolModeProperty.SelectionProp<T> property;
    protected T currentValue;

    public PropertyImageButton(int x, int y, OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        this(x, y, BuildingToolScreen.WIDGETS, 256, 256, onPress, name, property, currentVal);
    }

    public PropertyImageButton(int x, int y, ResourceLocation texture, int texWidth, int texHeight, OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        super(x, y, 100, 24, 50, 0, 24, texture, texWidth, texHeight, b -> {
            if (b instanceof PropertyImageButton) {
                onPress.onPress((PropertyImageButton)b);
            }
        }, property.getNameComponent());
        this.name = name;
        this.property = property;
        this.currentValue = currentVal;
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        Minecraft mc = Minecraft.m_91087_();
        int color = this.m_198029_() ? 0xFFFFFF : 0xCDCDCD;
        MutableComponent keyComp = Component.m_237113_((String)(this.name.getString() + ": "));
        int keyStartX = this.m_252754_() + 4;
        int keyY = this.m_252907_() + 8;
        graphics.m_280430_(mc.f_91062_, (Component)keyComp, keyStartX, keyY, color);
        int start = keyStartX + mc.f_91062_.m_92852_((FormattedText)keyComp);
        int end = this.m_252754_() + this.m_5711_() - 3;
        Component valueComp = this.property.getValueComponent(this.currentValue);
        PropertyImageButton.renderLeftAlignedScrollingString(graphics, mc.f_91062_, valueComp, start, end, keyY, this.m_93694_() + 10, color);
    }

    protected static void renderLeftAlignedScrollingString(GuiGraphics graphics, Font font, Component text, int xMinBounds, int xMaxBounds, int yPlacement, int yMargin, int color) {
        int xBounds;
        int width = font.m_92852_((FormattedText)text);
        if (width > (xBounds = xMaxBounds - xMinBounds)) {
            int delta = width - xBounds;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)delta * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double scrollAmount = Mth.m_14139_((double)d2, (double)0.0, (double)delta);
            graphics.m_280588_(xMinBounds, yPlacement - yMargin, xMaxBounds, yPlacement + yMargin);
            graphics.m_280430_(font, text, xMinBounds - (int)scrollAmount, yPlacement, color);
            graphics.m_280618_();
        } else {
            graphics.m_280430_(font, text, xMinBounds, yPlacement, color);
        }
    }

    public void cycleValue(boolean forward) {
        List<T> vals = this.property.getAllValues();
        int index = vals.indexOf(this.currentValue);
        index = forward ? --index : ++index;
        int size = vals.size();
        if (index >= size) {
            index = 0;
        }
        if (index < 0) {
            index = size - 1;
        }
        this.currentValue = (StringRepresentable)vals.get(index);
    }

    @Override
    public void m_5691_() {
        this.cycleValue(Screen.m_96638_());
        super.m_5691_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.m_198029_()) {
            boolean up = scroll > 0.0;
            this.cycleValue(!up);
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            super.m_5691_();
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public ToolModeProperty.SelectionProp<T> getProperty() {
        return this.property;
    }

    public T getSelectedValue() {
        return this.currentValue;
    }

    public static interface OnPress<T extends PropertyImageButton<?>> {
        public void onPress(T var1);
    }
}

