/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.processing;

import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.treeharvester_common_fabric.config.ConfigHandler;
import com.natamus.treeharvester_common_fabric.data.Variables;
import com.natamus.treeharvester_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import oshi.util.tuples.Triplet;

public class TreeProcessing {
    public static int isTreeAndReturnLogAmount(class_1937 level, class_2338 pos) {
        Variables.highestleaf.put(pos, 0);
        int leafcount = 8;
        int logCount = 0;
        int prevleafcount = -1;
        int prevlogCount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogCount != logCount); ++y) {
            prevleafcount = leafcount;
            prevlogCount = logCount;
            for (class_2338 npos : class_2338.method_10094((int)(pos.method_10263() - 2), (int)(pos.method_10264() + (y - 1)), (int)(pos.method_10260() - 2), (int)(pos.method_10263() + 2), (int)(pos.method_10264() + (y - 1)), (int)(pos.method_10260() + 2))) {
                class_2680 nblockState = level.method_8320(npos);
                class_2248 nblock = nblockState.method_26204();
                if (CompareBlockFunctions.isTreeLeaf((class_2248)nblock, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(nblock)) {
                    if (ConfigHandler.ignorePlayerMadeTrees && nblockState.method_28500((class_2769)class_2397.field_11200).orElse(false).booleanValue()) {
                        return -1;
                    }
                    --leafcount;
                    if (npos.method_10264() <= highesty) continue;
                    highesty = npos.method_10264();
                    continue;
                }
                if (!Util.isTreeLog(nblock)) continue;
                ++logCount;
            }
        }
        Variables.highestleaf.put(pos.method_10062(), highesty);
        if (leafcount < 0) {
            return logCount;
        }
        return -1;
    }

    public static List<class_2338> getAllLogsToBreak(class_1937 level, class_2338 pos, int logCount, class_2248 logType) {
        CopyOnWriteArrayList<class_2338> bottomlogs = new CopyOnWriteArrayList<class_2338>();
        if (ConfigHandler.replaceSaplingOnTreeHarvest) {
            class_2248 blockbelow = level.method_8320(pos.method_10074()).method_26204();
            if (Util.isPlantableBlock(blockbelow)) {
                Iterator it = class_2338.method_17962((int)(pos.method_10263() - 1), (int)pos.method_10264(), (int)(pos.method_10260() - 1), (int)(pos.method_10263() + 1), (int)pos.method_10264(), (int)(pos.method_10260() + 1)).iterator();
                while (it.hasNext()) {
                    class_2338 npos = (class_2338)it.next();
                    class_2248 block = level.method_8320(npos).method_26204();
                    if (!block.equals(logType) && !Util.areEqualLogTypes(logType, block)) continue;
                    bottomlogs.add(npos.method_10062());
                }
            }
            Variables.saplingPositions.add((Triplet<Date, class_2338, CopyOnWriteArrayList<class_2338>>)new Triplet((Object)new Date(), (Object)pos.method_10062(), bottomlogs));
        }
        return TreeProcessing.getLogsToBreak(level, pos, new ArrayList<class_2338>(), logCount, logType);
    }

    private static List<class_2338> getLogsToBreak(class_1937 level, class_2338 pos, List<class_2338> logsToBreak, int logCount, class_2248 logType) {
        if (logsToBreak.size() > 256) {
            return logsToBreak;
        }
        ArrayList<class_2338> checkAround = new ArrayList<class_2338>();
        boolean isMangrove = Util.isMangroveRootOrLog(logType);
        int downY = pos.method_10264() - 1;
        ArrayList<class_2338> aroundLogs = new ArrayList<class_2338>();
        for (class_2338 aL : class_2338.method_10094((int)(pos.method_10263() - 1), (int)pos.method_10264(), (int)(pos.method_10260() - 1), (int)(pos.method_10263() + 1), (int)(pos.method_10264() + 1), (int)(pos.method_10260() + 1))) {
            aroundLogs.add(aL.method_10062());
        }
        for (class_2338 aroundLogPos : aroundLogs) {
            class_2680 logstate;
            class_2248 logblock;
            if (logsToBreak.contains(aroundLogPos) || !(logblock = (logstate = level.method_8320(aroundLogPos)).method_26204()).equals(logType) && !Util.areEqualLogTypes(logType, logblock)) continue;
            if (!isMangrove || aroundLogPos.method_10264() != downY) {
                checkAround.add(aroundLogPos);
            }
            logsToBreak.add(aroundLogPos);
        }
        if (checkAround.size() == 0) {
            return logsToBreak;
        }
        for (class_2338 capos : checkAround) {
            for (class_2338 logpos : TreeProcessing.getLogsToBreak(level, capos, logsToBreak, logCount, logType)) {
                if (logsToBreak.contains(logpos)) continue;
                logsToBreak.add(logpos.method_10062());
            }
        }
        class_2338 up = pos.method_10086(2);
        return TreeProcessing.getLogsToBreak(level, up.method_10062(), logsToBreak, logCount, logType);
    }
}

