/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.RootedDirtBlock;
import net.minecraft.world.level.material.MapColor;

public class Util {
    public static boolean isTreeLog(Block block) {
        try {
            return (CompareBlockFunctions.isTreeLog((Block)block) || Util.isGiantMushroomStemBlock(block) || Util.isTreeRoot(block)) && !block.m_49954_().getString().toLowerCase().contains("stripped");
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public static boolean isTreeLeaf(Block block) {
        return CompareBlockFunctions.isTreeLeaf((Block)block, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(block);
    }

    public static boolean isSapling(Block block) {
        return CompareBlockFunctions.isSapling((Block)block) || block instanceof MushroomBlock && ConfigHandler.enableHugeMushrooms || block instanceof AzaleaBlock;
    }

    public static boolean isNetherTreeLeaf(Block block) {
        return block.equals(Blocks.f_50451_) || block.equals(Blocks.f_50692_) || block.equals(Blocks.f_50701_);
    }

    public static boolean isTreeRoot(Block block) {
        return block instanceof MangroveRootsBlock;
    }

    public static boolean isGiantMushroomStemBlock(Block block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        try {
            MapColor materialcolour = block.m_284356_();
            return block instanceof HugeMushroomBlock && materialcolour.equals(MapColor.f_283930_);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isGiantMushroomLeafBlock(Block block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        try {
            MapColor materialcolour = block.m_284356_();
            return block instanceof HugeMushroomBlock && (materialcolour.equals(MapColor.f_283913_) || materialcolour.equals(MapColor.f_283762_));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isMangroveRootOrLog(Block block) {
        return block instanceof MangroveRootsBlock || block.equals(Blocks.f_220832_);
    }

    public static boolean isAzaleaLeaf(Block block) {
        return block.equals(Blocks.f_152470_) || block.equals(Blocks.f_152471_);
    }

    public static boolean isPlantableBlock(Block block) {
        return block.m_49966_().m_204336_(BlockTags.f_144274_) || CompareBlockFunctions.isDirtBlock((Block)block) || block instanceof MyceliumBlock || block instanceof RootedDirtBlock;
    }

    public static boolean areEqualLogTypes(Block one, Block two) {
        if (!Util.isTreeLog(one) || !Util.isTreeLog(two)) {
            return false;
        }
        if (Util.isMangroveRootOrLog(one) && Util.isMangroveRootOrLog(two)) {
            return true;
        }
        String oneIdentifier = one.m_49954_().getString().split(" ")[0];
        String twoIdentifier = two.m_49954_().getString().split(" ")[0];
        return oneIdentifier.equals(twoIdentifier);
    }

    public static Pair<Boolean, List<BlockPos>> isConnectedToLogs(Level level, BlockPos startpos) {
        List recursiveList = BlockPosFunctions.getBlocksNextToEachOtherMaterial((Level)level, (BlockPos)startpos, Arrays.asList(MapColor.f_283825_), (int)6);
        for (BlockPos connectedpos : recursiveList) {
            Block connectedblock = level.m_8055_(connectedpos).m_60734_();
            if (!Util.isTreeLog(connectedblock)) continue;
            return new Pair((Object)true, (Object)recursiveList);
        }
        return new Pair((Object)false, (Object)recursiveList);
    }
}

