/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.vtaw_mw;

import com.minecraftserverzone.vtaw_mw.AbstractWeapon;
import com.minecraftserverzone.vtaw_mw.CustomThrowableItem;
import com.minecraftserverzone.vtaw_mw.ModItems;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownWeapon
extends AbstractWeapon {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack throwingItem = new ItemStack((ItemLike)Items.f_42713_);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public ThrownWeapon(EntityType<? extends ThrownWeapon> p_37561_, Level p_37562_) {
        super(p_37561_, p_37562_);
    }

    public void setThrowingItem(ItemStack s) {
        this.throwingItem = s.m_41777_();
    }

    public ThrownWeapon(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType<? extends AbstractWeapon>)((EntityType)ModItems.THROWN_WEAPON.get()), p_37570_, p_37569_);
        this.throwingItem = p_37571_.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)p_37571_)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)p_37571_.m_41790_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    @Override
    public void m_8119_() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.pickup == AbstractWeapon.Pickup.ALLOWED) {
                    this.m_5552_(this.getPickupItem(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @Override
    protected ItemStack getPickupItem() {
        return this.throwingItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Override
    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.findHitEntity(p_37575_, p_37576_);
    }

    @Override
    protected void m_5790_(EntityHitResult p_37573_) {
        Entity entity1;
        Entity entity = p_37573_.m_82443_();
        float f = 1.0f;
        if (this.getDefaultItem() instanceof CustomThrowableItem) {
            f = ((CustomThrowableItem)this.getDefaultItem()).getDamage();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.throwingItem, (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = ThrownWeapon.weapon(this, (Entity)((entity1 = this.m_19749_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.doPostHurtEffects(livingentity1);
            }
        }
        float f1 = 1.0f;
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundevent, f1, 1.0f);
    }

    @Override
    protected boolean tryPickup(Player p_150196_) {
        return super.tryPickup(p_150196_) || this.isNoPhysics() && this.m_150171_((Entity)p_150196_) && p_150196_.m_150109_().m_36054_(this.getPickupItem());
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.f_12514_;
    }

    @Override
    public void m_6123_(Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_19749_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    @Override
    public void m_7378_(CompoundTag p_37578_) {
        super.m_7378_(p_37578_);
        if (p_37578_.m_128425_("Weapon", 10)) {
            this.throwingItem = ItemStack.m_41712_((CompoundTag)p_37578_.m_128469_("Weapon"));
        }
        this.dealtDamage = p_37578_.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.throwingItem)));
    }

    @Override
    public void m_7380_(CompoundTag p_37582_) {
        super.m_7380_(p_37582_);
        p_37582_.m_128365_("Weapon", (Tag)this.throwingItem.m_41739_(new CompoundTag()));
        p_37582_.m_128379_("DealtDamage", this.dealtDamage);
    }

    @Override
    public void tickDespawn() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.pickup != AbstractWeapon.Pickup.ALLOWED || i <= 0) {
            super.tickDespawn();
        }
    }

    @Override
    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    @Override
    protected Item getDefaultItem() {
        if (this.getItemRaw() == null) {
            return ItemStack.f_41583_.m_41720_();
        }
        return this.throwingItem.m_41720_();
    }
}

