/*
 * Decompiled with CFR 0.152.
 */
package net.adorabuild.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.adorabuild.structures.AdorabuildStructuresMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;

public class EndJigsawStructure
extends Structure {
    public static final Codec<EndJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EndJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)100).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.INT.optionalFieldOf("min_absolute_height").forGetter(structure -> structure.minAbsoluteHeight), (App)Codec.INT.optionalFieldOf("max_absolute_height").forGetter(structure -> structure.maxAbsoluteHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.list((Codec)PoolAliasBinding.f_303072_).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.poolAliases)).apply((Applicative)instance, EndJigsawStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Integer> minAbsoluteHeight;
    private final Optional<Integer> maxAbsoluteHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<PoolAliasBinding> poolAliases;

    public EndJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Integer> minAbsoluteHeight, Optional<Integer> maxAbsoluteHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, List<PoolAliasBinding> poolAliases) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.minAbsoluteHeight = minAbsoluteHeight;
        this.maxAbsoluteHeight = maxAbsoluteHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.poolAliases = poolAliases;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos blockPos;
        int offsetY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        if (this.projectStartToHeightmap.isPresent()) {
            blockPos = new BlockPos(chunkPos.m_45604_(), offsetY, chunkPos.m_45605_());
        } else {
            int terrainY = context.f_226622_().m_214096_(chunkPos.m_45604_(), chunkPos.m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            if (this.minAbsoluteHeight.isPresent() && terrainY + offsetY < this.minAbsoluteHeight.get()) {
                return Optional.empty();
            }
            if (this.maxAbsoluteHeight.isPresent() && terrainY + offsetY > this.maxAbsoluteHeight.get()) {
                return Optional.empty();
            }
            blockPos = new BlockPos(chunkPos.m_45604_(), terrainY + offsetY, chunkPos.m_45605_());
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.m_307806_(this.poolAliases, (BlockPos)blockPos, (long)context.f_226627_()));
    }

    public StructureType<?> m_213658_() {
        return AdorabuildStructuresMod.END_JIGSAW_STRUCTURE.get();
    }
}

