/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.client.HookShotRenderer;
import com.endertech.minecraft.mods.adhooks.client.LauncherModel;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.init.Entities;
import com.endertech.minecraft.mods.adhooks.init.Items;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.network.JumpBoostMsg;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.SynchronizedProperties;
import com.endertech.minecraft.mods.adhooks.network.TarzanJumpMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adhooks")
public class AdHooks
extends AbstractForgeMod {
    public static final String ID = "adhooks";
    public static final String NAME = "Advanced Hook Launchers";
    private static AdHooks instance;
    public final Items items;
    public final Entities entities;

    public static AdHooks getInstance() {
        return instance;
    }

    public AdHooks() {
        instance = this;
        this.items = new Items(this);
        this.entities = new Entities(this);
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(WatchedBoolMsg::new);
        this.registerNetMessage(MakeShotMsg::new);
        this.registerNetMessage(JumpBoostMsg::new);
        this.registerNetMessage(TarzanJumpMsg::new);
        this.registerNetMessage(SynchronizedProperties::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            this.items.streamAll().filter(item -> {
                if (!(item instanceof Hook)) return true;
                Hook hook = (Hook)((Object)item);
                if (hook.type != HookType.PROTOTYPE) return true;
                return false;
            }).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }

    public void clientRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ControlBindings.register(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
        this.registerEntityRender((EntityType)this.entities.hookShot.get(), HookShotRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        for (HookType type : HookType.values()) {
            BakedModel hook = registry.getModelOf((Item)type.hook.get());
            BakedModel launcher = registry.getModelOf((Item)type.launcher.get());
            registry.replaceModelOf((Item)type.launcher.get(), (BakedModel)new LauncherModel(launcher, hook));
        }
    }
}

