/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

@OnlyIn(value=Dist.CLIENT)
public class ControlBindings {
    private static final Map<InteractionHand, Map<HookShot.WatchedBool, Optional<KeyMapping>>> keyBindingsByHand = new HashMap<InteractionHand, Map<HookShot.WatchedBool, Optional<KeyMapping>>>();

    public static Optional<KeyMapping> getKeyBindingFor(InteractionHand hand, HookShot.WatchedBool action) {
        return keyBindingsByHand.getOrDefault(hand, Collections.emptyMap()).getOrDefault((Object)action, Optional.empty());
    }

    public static boolean areKeysEqual(Optional<KeyMapping> mappingA, Optional<KeyMapping> mappingB) {
        if (mappingA.isPresent() && mappingB.isPresent()) {
            return mappingA.get().getKey().equals((Object)mappingB.get().getKey());
        }
        return mappingA.orElse(null) == mappingB.orElse(null);
    }

    public static boolean areSameForBothHands(HookShot.WatchedBool action) {
        return ControlBindings.areKeysEqual(ControlBindings.getKeyBindingFor(InteractionHand.MAIN_HAND, action), ControlBindings.getKeyBindingFor(InteractionHand.OFF_HAND, action));
    }

    public static boolean isKeyDownFor(InteractionHand hand, HookShot.WatchedBool action) {
        return ControlBindings.getKeyBindingFor(hand, action).map(kb -> kb.m_90857_()).orElse(false);
    }

    public static String getTextFor(InteractionHand hand, HookShot.WatchedBool action) {
        return ControlBindings.getKeyBindingFor(hand, action).map(kb -> kb.m_90863_().getString()).orElse("");
    }

    public static boolean conflictsWithAttackOrUse(Optional<KeyMapping> mapping) {
        Options gs = GameKeys.getGameSettings();
        return ControlBindings.areKeysEqual(mapping, Optional.of(gs.f_92096_)) || ControlBindings.areKeysEqual(mapping, Optional.of(gs.f_92095_));
    }

    private static KeyMapping mapping(InteractionHand hand, HookShot.WatchedBool action, KeyMapping defaultKeyBinding) {
        String handName = hand.name().toLowerCase(Locale.ROOT);
        String category = Names.dotted().join(new String[]{"key", "categories", "adhooks", handName});
        String description = Names.dotted().join(new String[]{"key", "adhooks", handName, action.getName()});
        KeyMapping keyMapping = new KeyMapping(description, (IKeyConflictContext)KeyConflictContext.IN_GAME, defaultKeyBinding.getKey().m_84868_(), defaultKeyBinding.getKey().m_84873_(), category);
        keyBindingsByHand.computeIfAbsent(hand, h -> new EnumMap(HookShot.WatchedBool.class)).put(action, Optional.of(keyMapping));
        return keyMapping;
    }

    public static void register(RegisterKeyMappingsEvent event) {
        Options gs = GameKeys.getGameSettings();
        for (InteractionHand hand : InteractionHand.values()) {
            KeyMapping kbAttackOrUse = hand == InteractionHand.MAIN_HAND ? gs.f_92096_ : gs.f_92095_;
            event.register(ControlBindings.mapping(hand, HookShot.WatchedBool.LAUNCHING, kbAttackOrUse));
            event.register(ControlBindings.mapping(hand, HookShot.WatchedBool.PULLING, kbAttackOrUse));
            event.register(ControlBindings.mapping(hand, HookShot.WatchedBool.JUMPING, gs.f_92089_));
            event.register(ControlBindings.mapping(hand, HookShot.WatchedBool.LOOSENING, gs.f_92091_));
            event.register(ControlBindings.mapping(hand, HookShot.WatchedBool.UNHOOKING, gs.f_92090_));
        }
    }
}

