/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.mods.adhooks.client.RopeRenderer;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class HookShotRenderer
extends EntityRenderer<HookShot> {
    public HookShotRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void renderHook(HookShot hookShot, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(partialTicks);
        double pixel = 0.0625;
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateYXZ(GameMath.getRadians((float)(180.0f + shotRotation.yaw)), GameMath.getRadians((float)shotRotation.pitch), 0.0f));
        if (hookType == HookType.WEB) {
            poseStack.m_85837_(0.0, -0.1, 0.0);
        } else {
            poseStack.m_85837_(-0.03125, 0.0, -0.4);
        }
        ItemStack hook = hookType == HookType.WEB ? Items.f_41863_.m_7968_() : ((Hook)((Object)hookType.hook.get())).m_7968_();
        Minecraft.m_91087_().m_91291_().m_269128_(hook, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, hookShot.m_9236_(), 0);
        poseStack.m_85849_();
    }

    public void render(HookShot hookShot, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!hookShot.isHookingEntity()) {
            this.renderHook(hookShot, yaw, partialTicks, poseStack, bufferSource, packedLight);
        }
        new RopeRenderer(hookShot, this.f_114476_, bufferSource, poseStack, packedLight).render(partialTicks);
        super.m_7392_((Entity)hookShot, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(HookShot entity) {
        return TextureAtlas.f_118259_;
    }
}

