/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class RopeRenderer {
    public static final RenderType RENDER_TYPE = RenderType.m_110446_((ResourceLocation)GameRendering.EMPTY_TEXTURE);
    protected final HookShot hookShot;
    protected final EntityRenderDispatcher renderManager;
    protected final VertexConsumer builder;
    protected final PoseStack poseStack;
    protected final ColorARGB color;
    protected final int light;

    public RopeRenderer(HookShot hookShot, EntityRenderDispatcher renderManager, MultiBufferSource buffer, PoseStack poseStack, int light) {
        this.hookShot = hookShot;
        this.renderManager = renderManager;
        this.builder = buffer.m_6299_(RENDER_TYPE);
        this.poseStack = poseStack;
        this.color = hookShot.getRope().color;
        this.light = light;
    }

    public void render(float partialTicks) {
        if (this.hookShot == null) {
            return;
        }
        LivingEntity shooter = this.hookShot.getShooter().orElse(null);
        if (shooter == null) {
            return;
        }
        Vect3d launcherPos = this.hookShot.getLauncherPosition(this.renderManager.f_114360_.m_92176_(), partialTicks);
        Vect3d hookShotPos = this.hookShot.getCurPosition(partialTicks);
        Vect3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = this.hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = (Rope)hookType.rope.get();
            float hookStrength = ((Hook)((Object)hookType.hook.get())).getStrength();
            float tensionForce = this.hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.getElasticity()) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = new FloatBounds(Rope.WIDTH_BOUNDS.getMin(), Float.valueOf(rope.getWidth())).interpolateDown(tensionFactor).floatValue();
            float sagging = this.hookShot.getSagging();
            Vect3d fromPoint = Vect3d.ZERO;
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                Objects.requireNonNull(rope);
                float ropeProgress = f / 16.0f;
                float sagHeight = Mth.m_14031_((float)(ropeProgress * (float)Math.PI)) * sagging;
                Vect3d toPoint = Vect3d.from((double)(ropeVec.x * (double)ropeProgress), (double)(ropeVec.y * (double)ropeProgress - (double)sagHeight), (double)(ropeVec.z * (double)ropeProgress));
                this.drawSegment(fromPoint, toPoint, ropeWidth);
                fromPoint = toPoint;
            }
        }
    }

    protected void vertex(PoseStack.Pose matrixEntry, double x, double y, double z, float u, float v) {
        this.builder.m_252986_(matrixEntry.m_252922_(), (float)x, (float)y, (float)z).m_6122_(this.color.getRed().value, this.color.getGreen().value, this.color.getBlue().value, this.color.getAlpha().value).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(this.light).m_252939_(matrixEntry.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
    }

    protected void drawSegment(Vect3d from, Vect3d to, float width) {
        Vect3d ropeVec = to.subtract(from);
        double length = ropeVec.length();
        double hw = (double)width / 2.0 * 0.01;
        this.poseStack.m_85836_();
        this.poseStack.m_85837_(from.x, from.y, from.z);
        this.poseStack.m_252781_(new Quaternionf().rotateYXZ(GameMath.getRadians((float)ropeVec.yaw()), GameMath.getRadians((float)(90.0f - ropeVec.pitch())), 0.0f));
        PoseStack.Pose matrixEntry = this.poseStack.m_85850_();
        for (int j = 0; j < 4; ++j) {
            this.vertex(matrixEntry, -hw, 0.0, hw, 0.0f, 0.0f);
            this.vertex(matrixEntry, hw, 0.0, hw, 1.0f, 0.0f);
            this.vertex(matrixEntry, hw, length, hw, 1.0f, 1.0f);
            this.vertex(matrixEntry, -hw, length, hw, 0.0f, 1.0f);
            this.poseStack.m_252781_(new Quaternionf().rotateY(GameMath.getRadians((float)90.0f)));
        }
        this.poseStack.m_85849_();
    }
}

