/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.hook;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Combustion;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.endertech.minecraft.mods.adhooks.motion.ClientPlayerTarget;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.MotionController;
import com.endertech.minecraft.mods.adhooks.network.JumpBoostMsg;
import com.endertech.minecraft.mods.adhooks.network.TarzanJumpMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HookShot
extends ForgeEntity {
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = 255;
    protected Direction hitSide = null;
    protected LivingEntity shooter = null;
    protected final Combustion combustion = new Combustion();

    public HookShot(EntityType<HookShot> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public HookShot(Level world, LivingEntity shooter, HookType hookType) {
        this((EntityType<HookShot>)((EntityType)AdHooks.getInstance().entities.hookShot.get()), world);
        this.shooter = shooter;
        this.f_19804_.m_135381_(WatchedInt.SHOOTER_ID.key, (Object)shooter.m_19879_());
        this.f_19804_.m_135381_(WatchedInt.HOOK_TYPE.key, (Object)hookType.ordinal());
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
    }

    protected void developMsg(String valueName, Object value) {
        ForgeEndertech.developMsg((String)((this.isClientSide() ? "CLIENT" : "SERVER") + ": " + valueName + " = " + value.toString()));
    }

    protected void m_8097_() {
        for (WatchedBool watchedBool : WatchedBool.values()) {
            this.f_19804_.m_135372_(watchedBool.key, (Object)false);
        }
        for (Enum enum_ : WatchedInt.values()) {
            this.f_19804_.m_135372_(((WatchedInt)enum_).key, (Object)0);
        }
        for (Enum enum_ : WatchedFloat.values()) {
            this.f_19804_.m_135372_(((WatchedFloat)enum_).key, (Object)Float.valueOf(0.0f));
        }
        this.setState(State.SHOOTING);
    }

    public boolean isLoosening() {
        return (Boolean)this.f_19804_.m_135370_(WatchedBool.LOOSENING.key);
    }

    public void setLoosening(boolean loosening) {
        if (this.isServerSide()) {
            this.f_19804_.m_135381_(WatchedBool.LOOSENING.key, (Object)loosening);
        }
    }

    public boolean isPulling() {
        return (Boolean)this.f_19804_.m_135370_(WatchedBool.PULLING.key);
    }

    public void setPulling(boolean pulling) {
        if (this.isServerSide()) {
            this.f_19804_.m_135381_(WatchedBool.PULLING.key, (Object)pulling);
        }
    }

    public State getPrevState() {
        int i = (Integer)this.f_19804_.m_135370_(WatchedInt.PREV_STATE.key);
        return State.values()[i];
    }

    public State getState() {
        int i = (Integer)this.f_19804_.m_135370_(WatchedInt.STATE.key);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState;
        if (this.isServerSide() && state != (prevState = this.getState())) {
            this.f_19804_.m_135381_(WatchedInt.PREV_STATE.key, (Object)prevState.ordinal());
            this.f_19804_.m_135381_(WatchedInt.STATE.key, (Object)state.ordinal());
        }
    }

    public float getRopeLength() {
        return ((Float)this.f_19804_.m_135370_(WatchedFloat.ROPE_LENGTH.key)).floatValue();
    }

    public void setRopeLength(float ropeLength) {
        if (this.isServerSide()) {
            this.f_19804_.m_135381_(WatchedFloat.ROPE_LENGTH.key, (Object)Float.valueOf(ropeLength));
        }
    }

    public float getSagging() {
        return ((Float)this.f_19804_.m_135370_(WatchedFloat.SAGGING.key)).floatValue();
    }

    public void setSagging(float sagging) {
        if (this.isServerSide()) {
            if (sagging < 0.0f) {
                sagging = 0.0f;
            }
            this.f_19804_.m_135381_(WatchedFloat.SAGGING.key, (Object)Float.valueOf(sagging));
        }
    }

    public HookType getHookType() {
        int ordinal = (Integer)this.f_19804_.m_135370_(WatchedInt.HOOK_TYPE.key);
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.PUDGE;
    }

    public BlockAction getBlockAction(Level level, BlockPos pos) {
        boolean reeling;
        if (GameWorld.isAirBlock((LevelReader)level, (BlockPos)pos)) {
            return BlockAction.PASS;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        HookType hookType = this.getHookType();
        Hook hook = (Hook)((Object)hookType.hook.get());
        boolean bl = reeling = this.getState() == State.REELING;
        if (hook.breaksGlass() && GameWorld.isGlassBlock((LevelReader)level, (BlockPos)pos)) {
            return BlockAction.BREAK;
        }
        switch (hookType) {
            case WEB: {
                if (hook.canHookAnyBlock()) {
                    return BlockAction.HOOK;
                }
                if (state.m_204336_(BlockTags.f_13029_)) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
            case PUDGE: {
                boolean isPole;
                if (state.m_204336_(BlockTags.f_13035_)) {
                    return BlockAction.HOOK;
                }
                if (block instanceof TorchBlock || block instanceof LanternBlock || block instanceof BellBlock) {
                    return BlockAction.BREAK;
                }
                if (state.m_204336_(BlockTags.f_13039_) || state.m_204336_(BlockTags.f_13055_)) {
                    return BlockAction.HOOK;
                }
                if (block instanceof IronBarsBlock && state.m_60827_() == SoundType.f_56743_) {
                    return BlockAction.HOOK;
                }
                VoxelShape collisionShape = state.m_60812_((BlockGetter)level, pos);
                if (collisionShape.m_83281_()) {
                    return BlockAction.BREAK;
                }
                double width = 0.15;
                VoxelShape poleShape = Shapes.m_83048_((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
                boolean bl2 = isPole = !Shapes.m_83157_((VoxelShape)collisionShape, (VoxelShape)poleShape, (BooleanOp)BooleanOp.f_82685_);
                if (isPole) {
                    return BlockAction.HOOK;
                }
                return BlockAction.BOUNCE;
            }
            case SPEAR: {
                float hardness;
                if (state.m_60827_() == SoundType.f_56736_) {
                    return BlockAction.HOOK;
                }
                if (!hook.canHookAnyBlock() && ((hardness = state.m_60800_((BlockGetter)level, pos)) < 0.0f || hardness > ((Hook)((Object)hookType.hook.get())).getStrength() / 2.0f)) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
        }
        return BlockAction.BOUNCE;
    }

    protected Vect3d getHitPosition() {
        return Vect3d.from((double)((Float)this.f_19804_.m_135370_(WatchedFloat.HIT_X.key)).floatValue(), (double)((Float)this.f_19804_.m_135370_(WatchedFloat.HIT_Y.key)).floatValue(), (double)((Float)this.f_19804_.m_135370_(WatchedFloat.HIT_Z.key)).floatValue());
    }

    public Vect3d getLauncherPosition() {
        return this.getShooter().map(shooter -> HookShot.getCenterPosition((Entity)shooter)).orElse(Vect3d.ZERO);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vect3d getLauncherPosition(CameraType pov, float partialTicks) {
        double dx;
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter == null) {
            return Vect3d.ZERO;
        }
        InteractionHand hand = this.getLauncherHand().orElse(null);
        double d = dx = hand != null ? 0.2 : 0.0;
        if (hand == InteractionHand.MAIN_HAND) {
            dx = -dx;
        }
        Vect3d offset = Vect3d.from((double)dx, (double)0.0, (double)0.0);
        float yaw = shooter.f_20883_;
        if (shooter instanceof LocalPlayer && pov == CameraType.FIRST_PERSON) {
            offset = offset.move(0.0, 0.0, -0.6);
            yaw = shooter.m_5675_(partialTicks);
        }
        offset = offset.rotateAroundY(-yaw);
        return HookShot.getCenterPosition((Entity)shooter, (float)partialTicks).add(offset);
    }

    public void setHitPosition(Vect3d hitPosition) {
        if (this.isServerSide() && hitPosition != null) {
            this.f_19804_.m_135381_(WatchedFloat.HIT_X.key, (Object)Float.valueOf((float)hitPosition.x));
            this.f_19804_.m_135381_(WatchedFloat.HIT_Y.key, (Object)Float.valueOf((float)hitPosition.y));
            this.f_19804_.m_135381_(WatchedFloat.HIT_Z.key, (Object)Float.valueOf((float)hitPosition.z));
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.HOOKING_BLOCK;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.HOOKING_ENTITY;
    }

    public Optional<InteractionHand> getLauncherHand() {
        int value = (Integer)this.f_19804_.m_135370_(WatchedInt.LAUNCHER_HAND.key);
        return value >= 0 ? Optional.of(InteractionHand.values()[value]) : Optional.empty();
    }

    protected void updateLauncherHand() {
        if (!this.isServerSide()) {
            return;
        }
        int value = -1;
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter != null) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack itemStack = shooter.m_21120_(hand);
                if (!Launcher.isAttachedToHookShot(itemStack, this)) continue;
                value = hand.ordinal();
                break;
            }
        }
        this.f_19804_.m_135381_(WatchedInt.LAUNCHER_HAND.key, (Object)value);
    }

    public BlockPos getHookedBlockPos() {
        return new BlockPos(((Integer)this.f_19804_.m_135370_(WatchedInt.HOOKED_BLOCK_X.key)).intValue(), ((Integer)this.f_19804_.m_135370_(WatchedInt.HOOKED_BLOCK_Y.key)).intValue(), ((Integer)this.f_19804_.m_135370_(WatchedInt.HOOKED_BLOCK_Z.key)).intValue());
    }

    protected void setHookedBlockPos(BlockHitResult hit) {
        if (this.isServerSide()) {
            BlockPos pos = hit.m_82425_();
            this.f_19804_.m_135381_(WatchedInt.HOOKED_BLOCK_X.key, (Object)pos.m_123341_());
            this.f_19804_.m_135381_(WatchedInt.HOOKED_BLOCK_Y.key, (Object)pos.m_123342_());
            this.f_19804_.m_135381_(WatchedInt.HOOKED_BLOCK_Z.key, (Object)pos.m_123343_());
        }
    }

    protected void onTargetHit(HitResult hit) {
        if (hit == null) {
            return;
        }
        if (this.getState() == State.REELING && !this.canHookOnReeling()) {
            return;
        }
        Vect3d hitPosition = Vect3d.from((Vec3)hit.m_82450_());
        if (hit instanceof BlockHitResult) {
            BlockHitResult trace = (BlockHitResult)hit;
            BlockPos pos = trace.m_82425_();
            BlockAction action = this.getBlockAction(this.m_9236_(), pos);
            if (action == BlockAction.BOUNCE && this.getHook().canHookAnyBlock()) {
                action = BlockAction.HOOK;
            }
            switch (action) {
                case HOOK: {
                    break;
                }
                case BREAK: {
                    if (this.isServerSide()) {
                        BlockState state = this.m_9236_().m_8055_(pos);
                        this.m_9236_().m_46961_(pos, state.m_60827_() != SoundType.f_56744_);
                    }
                }
                case BOUNCE: {
                    this.setState(State.REELING);
                }
                default: {
                    return;
                }
            }
            this.hitSide = trace.m_82434_();
            Vect3d offsetVec = Vect3d.from((Vec3i)this.hitSide.m_122436_()).scale(0.05);
            hitPosition = hitPosition.add(offsetVec);
            this.setHookedBlockPos(trace);
            this.setHitPosition(hitPosition);
            this.setState(State.HOOKING_BLOCK);
        } else if (hit instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)hit).m_82443_();
            if (target instanceof EnderDragonPart) {
                target = ((EnderDragonPart)target).f_31010_;
            }
            if (!this.canBeAttachedTo(target)) {
                return;
            }
            float damage = ((Hook)((Object)this.getHookType().hook.get())).getDamage();
            if (damage > 0.0f && this.getShooter().isPresent()) {
                target.m_6469_(this.m_269291_().m_269299_((Entity)this, this.getShooter().get()), damage);
            }
            this.f_19804_.m_135381_(WatchedInt.HOOKED_ENTITY_ID.key, (Object)target.m_19879_());
            this.setState(State.HOOKING_ENTITY);
        } else {
            return;
        }
        float ropeLength = (float)(this.getLauncherPosition().distance(hitPosition) + (double)((Launcher)((Object)this.getHookType().launcher.get())).getReelingSpeed());
        this.setRopeLength(ropeLength);
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected boolean canBeAttachedTo(Entity entity) {
        HookType type = this.getHookType();
        Hook hook = (Hook)((Object)type.hook.get());
        if (entity == null || hook == null || !this.getShooter().isPresent()) {
            return false;
        }
        if (entity instanceof Player) {
            return hook.affectsPlayers();
        }
        if (entity instanceof ItemEntity) {
            return hook.affectsItems();
        }
        return hook.affectsNPCs();
    }

    public double m_20204_() {
        return super.m_20204_();
    }

    protected void updatePhysics() {
        ServerPlayer player;
        Entity hookedEntity;
        HookType hookType = this.getHookType();
        State state = this.getState();
        LivingEntity shooter = this.getShooter().orElse(null);
        Entity entity = hookedEntity = state == State.HOOKING_ENTITY ? (Entity)this.findHookedEntity().orElse(null) : null;
        if (shooter == null || !shooter.m_6084_()) {
            this.m_146870_();
            return;
        }
        if (shooter instanceof ServerPlayer && Launcher.findAttachedLauncher((player = (ServerPlayer)shooter).m_150109_(), this).isEmpty()) {
            this.m_146870_();
            return;
        }
        Vect3d launcherPosition = this.getLauncherPosition();
        Vect3d tensionVec = Vect3d.ZERO;
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        Vect3d hookPosition = this.getCurPosition();
        FloatBounds ropeLengthBounds = ((Rope)hookType.rope.get()).getLengthBounds(shooter, hookedEntity);
        float ropeLength = ropeLengthBounds.enclose(Float.valueOf(this.getRopeLength())).floatValue();
        float reelingSpeed = ((Launcher)((Object)hookType.launcher.get())).getReelingSpeed();
        switch (state) {
            case SHOOTING: {
                ropeLength = hookDistance + reelingSpeed;
                if (!(ropeLength > ropeLengthBounds.getMax().floatValue())) break;
                this.setState(State.REELING);
                return;
            }
            case REELING: {
                float reelingSpeedMult = 4.0f;
                if (this.isPulling()) {
                    reelingSpeedMult *= 2.0f;
                }
                Vect3d motionVec = launcherPosition.subtract(hookPosition).resize((double)(reelingSpeed * reelingSpeedMult));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.distance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeLengthBounds.getMin().floatValue()) && !(hookDistance <= hookNextDistance)) break;
                this.m_146870_();
                return;
            }
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = ((Rope)hookType.rope.get()).getTensionForce(ropeLength, hookDistance);
                tensionVec = hookPosition.subtract(launcherPosition).resize((double)tensionForce);
                float hookStrength = ((Hook)((Object)hookType.hook.get())).getStrength();
                if (tensionForce > hookStrength) {
                    this.setState(State.REELING);
                    return;
                }
                HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
                break;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: {
                if (hookType == HookType.PUDGE && ropeLength <= ropeLengthBounds.getMin().floatValue()) {
                    if (((Boolean)this.f_19804_.m_135370_(WatchedBool.JUMPING.key)).booleanValue()) {
                        this.doJumpBoost();
                    }
                    this.m_146870_();
                    return;
                }
                this.addMotionTo((Entity)shooter, tensionVec);
                break;
            }
            case HOOKING_ENTITY: {
                float targetWeight;
                if (hookedEntity == null) {
                    this.setState(State.REELING);
                    return;
                }
                if (ropeLength <= hookDistance || tensionVec.notZero()) {
                    HookShot.setFallDistance((Entity)hookedEntity, (float)0.0f, (boolean)true);
                }
                if (hookType == HookType.PUDGE && ropeLength <= ropeLengthBounds.getMin().floatValue()) {
                    hookedEntity.m_6034_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
                    this.m_146870_();
                    return;
                }
                float shooterWeight = HookShot.getWeight((Entity)shooter, (boolean)false) * ((Launcher)((Object)hookType.launcher.get())).getShooterWeightFactor();
                float totalWeight = (shooterWeight += HookShot.getWeight((Entity)shooter, (boolean)true)) + (targetWeight = HookShot.getWeight((Entity)hookedEntity, (boolean)true));
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                this.addMotionTo(hookedEntity, tensionVec.invert().scale((double)(shooterWeight / totalWeight)));
                this.addMotionTo((Entity)shooter, tensionVec.scale((double)(targetWeight / totalWeight)));
                break;
            }
        }
        ropeLength = ropeLengthBounds.enclose(Float.valueOf(ropeLength)).floatValue();
        if (this.isServerSide()) {
            this.setRopeLength(ropeLength);
            this.setSagging(ropeLength - hookDistance);
            this.setState(state);
            this.setTensionForce(tensionForce);
        }
    }

    protected void setTensionForce(float tensionForce) {
        if (this.isServerSide()) {
            this.f_19804_.m_135381_(WatchedFloat.TENSION_FORCE.key, (Object)Float.valueOf(tensionForce));
        }
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().distance(this.getCurPosition());
    }

    protected void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        LivingEntity shooter = this.getShooter().orElse(null);
        InteractionHand launcherHand = this.getLauncherHand().orElse(null);
        if (hookType == null || shooter == null || launcherHand == null) {
            return;
        }
        State state = this.getState();
        float ropeLength = this.getRopeLength();
        float pullingSpeed = ((Launcher)((Object)hookType.launcher.get())).getReelingSpeed();
        if (((Boolean)this.m_20088_().m_135370_(WatchedBool.DOUBLE_JUMPING.key)).booleanValue() && !shooter.m_20096_() && (CommonMath.notZero((double)this.getTensionForce()) || ropeLength <= this.getHookDistance())) {
            boolean properlyAttached;
            switch (state) {
                case HOOKING_ENTITY: {
                    boolean bl = this.findHookedEntity().map(entity -> entity.m_20186_() > shooter.m_20186_()).orElse(false);
                    break;
                }
                case HOOKING_BLOCK: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = properlyAttached = false;
                }
            }
            if (properlyAttached) {
                this.doTarzanJump();
                this.doJumpBoost();
                this.setState(State.REELING);
                return;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (this.isPulling()) {
                    ropeLength -= pullingSpeed;
                }
                if (hookType == HookType.PUDGE) {
                    ropeLength -= pullingSpeed * 2.0f;
                    break;
                }
                if (!this.isLoosening()) break;
                ropeLength += pullingSpeed;
            }
        }
        if (((Boolean)this.f_19804_.m_135370_(WatchedBool.UNHOOKING.key)).booleanValue()) {
            ropeLength -= (pullingSpeed *= 4.0f);
            if (((Boolean)this.f_19804_.m_135370_(WatchedBool.JUMPING.key)).booleanValue() && state == State.HOOKING_BLOCK && (CommonMath.notZero((double)this.getTensionForce()) || ropeLength <= this.getHookDistance())) {
                this.doJumpBoost();
            }
            this.setState(State.REELING);
            return;
        }
        if (state == State.HOOKING_BLOCK && shooter.m_20142_() && CommonMath.notZero((double)this.getTensionForce())) {
            ropeLength += pullingSpeed;
        }
        if (ropeLength < 0.0f) {
            ropeLength = 0.0f;
        }
        this.setRopeLength(ropeLength);
    }

    public Rope getRope() {
        return (Rope)this.getHookType().rope.get();
    }

    public Launcher getLauncher() {
        return (Launcher)((Object)this.getHookType().launcher.get());
    }

    public Hook getHook() {
        return (Hook)((Object)this.getHookType().hook.get());
    }

    protected void addMotionTo(Entity entity, Vect3d motion) {
        if (motion.isZero()) {
            return;
        }
        EntityTarget target = MotionController.getTarget(entity.m_20201_()).orElse(null);
        if (target != null) {
            target.addDampedMotion(motion);
            if (HookShot.isClientSide((Entity)entity) && target instanceof ClientPlayerTarget) {
                ((ClientPlayerTarget)target).updateSwinging();
            }
        }
    }

    public void m_20258_(CompoundTag compound) {
        this.m_146870_();
    }

    public boolean m_5829_() {
        return false;
    }

    public Optional<LivingEntity> getShooter() {
        Entity entity;
        if (this.shooter == null && (entity = (Entity)GameWorld.getEntity((Level)this.m_9236_(), (int)((Integer)this.f_19804_.m_135370_(WatchedInt.SHOOTER_ID.key))).orElse(null)) instanceof LivingEntity) {
            this.shooter = (LivingEntity)entity;
        }
        return Optional.ofNullable(this.shooter);
    }

    public Block getHookedBlock() {
        return this.m_9236_().m_8055_(this.getHookedBlockPos()).m_60734_();
    }

    public boolean hookedBlockExists() {
        return this.getHookedBlock() != Blocks.f_50016_;
    }

    public Optional<Entity> findHookedEntity() {
        return HookShot.getById((Level)this.m_9236_(), (int)((Integer)this.f_19804_.m_135370_(WatchedInt.HOOKED_ENTITY_ID.key)));
    }

    public void m_8119_() {
        super.m_8119_();
        this.move();
        this.setPrevRotation(this.getCurRotation());
        this.updateLauncherHand();
        this.updateControlling();
        this.updateCombustion();
        this.updatePhysics();
        this.updateCollisions();
        this.updateTargetState();
        this.updateMotion();
        this.updateRotation();
    }

    protected void updateCombustion() {
        if (this.isServerSide()) {
            double fireResistance = ((Hook)((Object)this.getHookType().hook.get())).getResistance();
            boolean fireInfluenced = false;
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    fireInfluenced = this.m_9236_().m_8055_(this.getHookedBlockPos().m_121945_(this.hitSide)).m_60713_(Blocks.f_50083_);
                    break;
                }
                case HOOKING_ENTITY: {
                    fireInfluenced = this.findHookedEntity().map(Entity::m_6060_).orElse(false);
                    break;
                }
            }
            if (this.m_6060_()) {
                this.combustion.fire();
            }
            if (this.combustion.getFireInfluencedTime().inSeconds() > fireResistance) {
                this.combustion.fire();
            }
            if (this.combustion.isBurning()) {
                this.m_20254_(1);
            }
            if (this.combustion.getBurningTime().inSeconds() > fireResistance) {
                this.m_6074_();
            }
            this.combustion.update(fireInfluenced);
        }
    }

    protected void updateCollisions() {
        if (!this.isServerSide()) {
            return;
        }
        State state = this.getState();
        if (this.isHookingTarget()) {
            return;
        }
        if (state == State.REELING) {
            if (!this.canHookOnReeling()) {
                return;
            }
            if (this.getHookType() == HookType.PUDGE && this.getPrevState() == State.HOOKING_ENTITY) {
                return;
            }
        }
        ArrayList<EntityHitResult> allHits = new ArrayList<EntityHitResult>();
        ClipContext.Block blockMode = this.getHookType() == HookType.PUDGE && state == State.REELING ? ClipContext.Block.OUTLINE : ClipContext.Block.COLLIDER;
        GameWorld.rayTraceBlocks((Level)this.m_9236_(), (Vect3d)this.getPrevPosition(), (Vect3d)this.getCurPosition(), (ClipContext.Block)blockMode, (ClipContext.Fluid)ClipContext.Fluid.NONE, (Entity)this).ifPresent(allHits::add);
        AABB aabb = this.getBB().m_82369_(this.m_20184_()).m_82400_(1.0);
        List entities = this.m_9236_().m_45933_((Entity)this, aabb);
        Entity shooter = this.getShooter().orElse(null);
        Entity vehicle = shooter != null ? shooter.m_20202_() : null;
        for (Entity target : entities) {
            Optional hit;
            if (target == shooter && state == State.REELING) {
                this.m_146870_();
                return;
            }
            if (!this.isServerSide() || target == this || target == shooter || target == vehicle || !(hit = HookShot.getBB((Entity)target).m_82400_((double)target.m_6143_()).m_82400_(0.2).m_82371_(this.getCurPosition().toVector3d(), this.getNextPosition().toVector3d())).isPresent()) continue;
            allHits.add(new EntityHitResult(target, HookShot.getCenterPosition((Entity)target).toVector3d()));
        }
        HitResult nearestHit = null;
        double minDistance = Double.MAX_VALUE;
        for (HitResult hitResult : allHits) {
            double distance = this.getCurPosition().distance(Vect3d.from((Vec3)hitResult.m_82450_()));
            if (!(distance < minDistance)) continue;
            nearestHit = hitResult;
            minDistance = distance;
        }
        if (nearestHit != null) {
            this.onTargetHit(nearestHit);
        }
    }

    protected void updateTargetState() {
        if (this.isServerSide()) {
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    if (this.hookedBlockExists()) break;
                    this.setState(State.REELING);
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity().orElse(null);
                    if (!(entity == null || !entity.m_6084_() || entity instanceof LivingEntity && ((LivingEntity)entity).f_20911_ && entity.m_6047_() || entity instanceof Player && entity.m_20159_() && ((Player)entity).f_20911_) && !HookShot.hasSwingingPlayerPassenger((Entity)entity)) break;
                    this.setState(State.REELING);
                    break;
                }
            }
        }
    }

    public boolean isHookingTarget() {
        return switch (this.getState()) {
            case State.HOOKING_BLOCK, State.HOOKING_ENTITY -> true;
            default -> false;
        };
    }

    protected void updateRotation() {
        if (this.isHookingTarget()) {
            this.setAllRotations(this.getCurRotation());
        } else {
            Vect3d motion = this.getCurMotion();
            if (motion.notZero()) {
                if (this.getState() == State.REELING) {
                    motion = motion.invert();
                }
                this.setCurRotation(motion.rotation());
            }
        }
    }

    protected void updateMotion() {
        State state = this.getState();
        switch (state) {
            case HOOKING_BLOCK: {
                if (!this.hookedBlockExists()) break;
                this.setAllPositions(this.getHitPosition());
                this.stopMoving();
                this.m_6853_(true);
                break;
            }
            case HOOKING_ENTITY: {
                if (!this.m_20159_()) {
                    this.findHookedEntity().ifPresent(entity -> {
                        this.stopMoving();
                        this.m_7998_((Entity)entity, true);
                        if (this.getHookType() == HookType.PUDGE) {
                            entity.m_8127_();
                        }
                    });
                }
                this.m_6853_(true);
                break;
            }
            default: {
                if (this.m_20159_()) {
                    this.m_8127_();
                }
                this.m_6853_(true);
                double motionFactor = 0.99f;
                if (this.m_20069_()) {
                    Vect3d bubblePos = this.getCurPosition().subtract(this.getCurMotion().scale(0.25));
                    for (int i = 0; i < 4; ++i) {
                        GameWorld.spawnParticle((Level)this.m_9236_(), (Vect3d)bubblePos, (Vect3d)this.getCurMotion(), (ParticleOptions)ParticleTypes.f_123795_);
                    }
                    motionFactor = 0.8f;
                }
                this.m_20256_(this.m_20184_().m_82490_(motionFactor).m_82520_(0.0, (double)-0.005f, 0.0));
            }
        }
    }

    public void launch(Vec3 direction, float velocity, float inaccuracy) {
        Vect3d motion = Vect3d.from((Vec3)direction).scale((double)velocity);
        this.setMotion(motion);
        Rotation rotation = new Rotation(motion.pitch(), motion.yaw());
        this.setAllRotations(rotation);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 1.2f) + 0.5f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof Player) {
            Inventory inventory = ((Player)shooter).m_150109_();
            Launcher.findAttachedLauncher(inventory, this).ifPresent(Launcher::unattach);
        }
        super.m_142687_(reason);
    }

    public float getTensionForce() {
        return ((Float)this.f_19804_.m_135370_(WatchedFloat.TENSION_FORCE.key)).floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 65025.0;
    }

    protected void doJumpBoost() {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof ServerPlayer) {
            float strength = this.getLauncher().getJumpBoostStrength();
            new JumpBoostMsg(strength).sendTo((ServerPlayer)shooter);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    public void doTarzanJump() {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof ServerPlayer) {
            float strength = this.getLauncher().getTarzanJumpStrength();
            new TarzanJumpMsg(strength).sendTo((ServerPlayer)shooter);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public static enum WatchedInt {
        HOOKED_BLOCK_X,
        HOOKED_BLOCK_Y,
        HOOKED_BLOCK_Z,
        HOOKED_ENTITY_ID,
        HOOK_TYPE,
        PREV_STATE,
        SHOOTER_ID,
        STATE,
        LAUNCHER_HAND;

        public final EntityDataAccessor<Integer> key = SynchedEntityData.m_135353_(HookShot.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    public static enum WatchedBool implements IForgeEnum
    {
        LAUNCHING,
        PULLING,
        LOOSENING,
        UNHOOKING,
        JUMPING,
        DOUBLE_JUMPING;

        public final EntityDataAccessor<Boolean> key = SynchedEntityData.m_135353_(HookShot.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static enum WatchedFloat {
        HIT_X,
        HIT_Y,
        HIT_Z,
        ROPE_LENGTH,
        SAGGING,
        TENSION_FORCE;

        public final EntityDataAccessor<Float> key = SynchedEntityData.m_135353_(HookShot.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }

    public static enum State {
        SHOOTING,
        REELING,
        HOOKING_BLOCK,
        HOOKING_ENTITY;

    }

    static enum BlockAction {
        BOUNCE,
        BREAK,
        HOOK,
        PASS;

    }
}

