/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Launcher
extends DamageableItem
implements INBTSerializable<Launcher> {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final int DAMAGE_ON_SHOT = 1;
    public final HookType hookType;
    protected float reelingSpeed;
    protected float launchVelocity;
    protected float jumpBoostStrength;
    protected float tarzanJumpStrength;
    protected float shooterWeightFactor;
    protected final Map<InteractionHand, Cooldowns> cooldownsByHand = new EnumMap<InteractionHand, Cooldowns>(InteractionHand.class);
    protected final Map<InteractionHand, WatchedStates> watchedStatesByHand = new EnumMap<InteractionHand, WatchedStates>(InteractionHand.class);

    public Launcher(UnitConfig config, HookType hookType, Properties<?> props) {
        super(config, props);
        this.hookType = hookType;
        String category = props.name;
        this.launchVelocity = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"launchVelocity", (float)props.launchVelocity, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.1f), (Float)Float.valueOf(10.0f)), (String)"Defines the launch velocity of the hook");
        this.reelingSpeed = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"reelingSpeed", (float)props.reelingSpeed, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.1f), (Float)Float.valueOf(4.0f)), (String)"Defines how fast the launcher reels in the rope");
        this.jumpBoostStrength = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"jumpBoostStrength", (float)props.jumpBoostStrength, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(3.0f)), (String)"Defines how high you will be thrown when performing Jump Boost or Tarzan Jump");
        this.tarzanJumpStrength = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"tarzanJumpStrength", (float)props.tarzanJumpStrength, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(3.0f)), (String)"Defines how far you will be thrown when performing Tarzan Jump");
        this.shooterWeightFactor = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"shooterWeightFactor", (float)props.shooterWeightFactor, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1000.0f)), (String)"Allows to adjust your weight advantage/disadvantage over the hooked entity");
    }

    public float getLaunchVelocity() {
        return this.launchVelocity;
    }

    public float getReelingSpeed() {
        return this.reelingSpeed;
    }

    public float getJumpBoostStrength() {
        return this.jumpBoostStrength;
    }

    public float getTarzanJumpStrength() {
        return this.tarzanJumpStrength;
    }

    public float getShooterWeightFactor() {
        return this.shooterWeightFactor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag flag) {
        Options gs = GameKeys.getGameSettings();
        Tooltip tip = Tooltip.of((AbstractForgeMod)AdHooks.getInstance(), (String)"launcher", lines);
        ChatFormatting formText = ChatFormatting.RESET;
        if (Screen.m_96638_()) {
            tip.add(ChatFormatting.RED, "hook_strength", (Object)Float.valueOf(((Hook)((Object)this.hookType.hook.get())).strength));
            tip.add(ChatFormatting.AQUA, "rope_elasticity", (Object)Float.valueOf(((Rope)this.hookType.rope.get()).elasticity));
            tip.add(ChatFormatting.YELLOW, "rope_max_length", (Object)((Rope)this.hookType.rope.get()).maxLength);
            tip.add(ChatFormatting.GREEN, "reeling_speed", (Object)Float.valueOf(this.reelingSpeed));
            tip.add(ChatFormatting.DARK_PURPLE, "jump_boost_strength", (Object)Float.valueOf(this.jumpBoostStrength));
            tip.add(ChatFormatting.GOLD, "tarzan_jump_strength", (Object)Float.valueOf(this.tarzanJumpStrength));
        } else if (Screen.m_96637_()) {
            for (InteractionHand hand : InteractionHand.values()) {
                String textUnhooking = ControlBindings.getTextFor(hand, HookShot.WatchedBool.UNHOOKING);
                String textLoosening = ControlBindings.getTextFor(hand, HookShot.WatchedBool.LOOSENING);
                String handName = hand.name().toLowerCase(Locale.ROOT);
                tip.add(handName, new Object[]{ChatFormatting.UNDERLINE});
                String textLaunching = ControlBindings.getTextFor(hand, HookShot.WatchedBool.LAUNCHING);
                tip.add("launch", new Object[]{ChatFormatting.RED, formText, textLaunching});
                String textPulling = ControlBindings.getTextFor(hand, HookShot.WatchedBool.PULLING);
                if (ControlBindings.areSameForBothHands(HookShot.WatchedBool.UNHOOKING)) {
                    tip.add("reel_unhook_same", new Object[]{ChatFormatting.GREEN, formText, textPulling, textUnhooking});
                } else {
                    tip.add("reel_unhook", new Object[]{ChatFormatting.GREEN, formText, textUnhooking});
                }
                tip.add("pull", new Object[]{ChatFormatting.YELLOW, formText, textPulling});
                if (ControlBindings.areSameForBothHands(HookShot.WatchedBool.LOOSENING)) {
                    tip.add("loosen_same", new Object[]{ChatFormatting.AQUA, formText, textPulling, textLoosening});
                } else {
                    tip.add("loosen", new Object[]{ChatFormatting.AQUA, formText, textLoosening});
                }
                tip.add("jump_boost", new Object[]{ChatFormatting.DARK_PURPLE, formText, textUnhooking, ControlBindings.getTextFor(hand, HookShot.WatchedBool.JUMPING)});
                tip.add("tarzan_jump", new Object[]{ChatFormatting.GOLD, formText, ControlBindings.getTextFor(hand, HookShot.WatchedBool.JUMPING)});
            }
            tip.add("other", new Object[]{ChatFormatting.UNDERLINE});
            tip.add("swing", new Object[]{ChatFormatting.BLUE, formText, Args.joinDelim((String)"-", (Object[])new Object[]{gs.f_92086_.m_90863_().getString(), gs.f_92088_.m_90863_().getString(), gs.f_92087_.m_90863_().getString(), gs.f_92085_.m_90863_().getString()})});
            tip.add("release", new Object[]{ChatFormatting.LIGHT_PURPLE, formText, gs.f_92096_.m_90863_().getString(), gs.f_92090_.m_90863_().getString()});
            tip.add("repair", new Object[]{ChatFormatting.DARK_GRAY, formText});
        } else {
            tip.add("more_info", new Object[]{ChatFormatting.GRAY, ChatFormatting.DARK_PURPLE});
            tip.add("controls", new Object[]{ChatFormatting.GRAY, ChatFormatting.DARK_PURPLE});
        }
    }

    public static boolean isShotAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.m_41782_() && launcher.m_41783_().m_128441_(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isShotAttached(launcher) && Launcher.getAttachedHookShotId(launcher) == hookShot.m_19879_();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher.m_41782_()) {
            return launcher.m_41783_().m_128451_(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack.m_41720_() instanceof Launcher;
    }

    public static Optional<HookShot> findAttachedHookShot(ItemStack launcher, Level world) {
        Entity entity;
        if (Launcher.isShotAttached(launcher) && (entity = world.m_6815_(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return Optional.of((HookShot)entity);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> findAttachedLauncher(Inventory inventory, HookShot hookShot) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            ItemStack stack = inventory.m_8020_(slot);
            if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            CompoundTag tag = launcher.m_41784_();
            tag.m_128405_(TAG_HOOKSHOT_ID, hookShot.m_19879_());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && launcher.m_41782_()) {
            launcher.m_41783_().m_128473_(TAG_HOOKSHOT_ID);
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        stack.m_41784_();
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack launcher, Player player, Entity entity) {
        return this.hookType != HookType.PUDGE;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void makeShot(ItemStack launcher, LivingEntity shooter) {
        HookShot hookShot;
        Level level = shooter.m_9236_();
        if (GameWorld.isServerSide((LevelReader)level) && this.hookType != HookType.PROTOTYPE && Launcher.notBroken((ItemStack)launcher) && level.m_7967_((Entity)(hookShot = new HookShot(level, shooter, this.hookType)))) {
            hookShot.launch(shooter.m_20154_(), this.getLaunchVelocity(), 1.0f);
            Launcher.attachToHookShot(launcher, hookShot);
            Launcher.damageItem((int)1, (ItemStack)launcher, (boolean)false, (LivingEntity)shooter, null);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND || !Launcher.stackHasLauncher(player.m_21206_())) {
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void processPressedKeysBy(LocalPlayer player, InteractionHand activeHand) {
        if (!GameKeys.affectPlayer()) {
            return;
        }
        Cooldowns cooldowns = this.cooldownsByHand.computeIfAbsent(activeHand, Cooldowns::new);
        WatchedStates states = this.watchedStatesByHand.computeIfAbsent(activeHand, WatchedStates::new);
        ItemStack activeItem = player.m_21120_(activeHand);
        boolean kdJumping = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.JUMPING);
        boolean kdLaunching = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.LAUNCHING);
        boolean kdPulling = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.PULLING);
        boolean kdLoosening = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.LOOSENING);
        boolean kdUnhooking = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.UNHOOKING);
        boolean shotAttached = Launcher.isShotAttached(activeItem);
        Function<HookShot.WatchedBool, Boolean> kdDoubleJumping = key -> {
            if (kdJumping) {
                if (!cooldowns.maxxed((HookShot.WatchedBool)((Object)key)) && !cooldowns.expired((HookShot.WatchedBool)((Object)key))) {
                    cooldowns.reset((HookShot.WatchedBool)((Object)key));
                    cooldowns.reset(HookShot.WatchedBool.LAUNCHING);
                    return true;
                }
                cooldowns.set((HookShot.WatchedBool)((Object)key), 4);
            } else {
                cooldowns.tick((HookShot.WatchedBool)((Object)key));
            }
            return false;
        };
        if (shotAttached) {
            cooldowns.tickIfTrueElseZero(HookShot.WatchedBool.UNHOOKING, b -> kdUnhooking);
        } else {
            cooldowns.tickIfTrueElseZero(HookShot.WatchedBool.LAUNCHING, b -> kdLaunching);
        }
        if (kdLaunching && !shotAttached) {
            HitResult result = Minecraft.m_91087_().f_91077_;
            Optional<KeyMapping> launching = ControlBindings.getKeyBindingFor(activeHand, HookShot.WatchedBool.LAUNCHING);
            if ((result == null || result.m_6662_() == HitResult.Type.MISS || !ControlBindings.conflictsWithAttackOrUse(launching)) && cooldowns.expired(HookShot.WatchedBool.LAUNCHING)) {
                new MakeShotMsg(activeHand).sendToServer();
                cooldowns.reset(HookShot.WatchedBool.UNHOOKING);
                states.bools.clear();
            }
        }
        states.updateAndSync(HookShot.WatchedBool.PULLING, pulling -> kdPulling && !kdLoosening);
        states.updateAndSync(HookShot.WatchedBool.LOOSENING, loosening -> ControlBindings.areSameForBothHands(loosening) ? kdLoosening && kdPulling : kdLoosening && !kdPulling);
        states.updateAndSync(HookShot.WatchedBool.UNHOOKING, unhooking -> shotAttached && cooldowns.expired((HookShot.WatchedBool)((Object)unhooking)) && (ControlBindings.areSameForBothHands(unhooking) ? kdUnhooking && kdPulling : kdUnhooking));
        states.updateAndSync(HookShot.WatchedBool.JUMPING, jumping -> kdJumping);
        states.updateAndSync(HookShot.WatchedBool.DOUBLE_JUMPING, kdDoubleJumping);
        if (states.get(HookShot.WatchedBool.UNHOOKING)) {
            cooldowns.reset(HookShot.WatchedBool.LAUNCHING);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int inventorySlot, boolean isCurrentItem) {
        if (level.f_46443_ && entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            Optional<InteractionHand> activeHand = Optional.empty();
            for (InteractionHand hand2 : InteractionHand.values()) {
                if (stack != player.m_21120_(hand2)) continue;
                activeHand = Optional.of(hand2);
            }
            activeHand.ifPresent(hand -> this.processPressedKeysBy(player, (InteractionHand)hand));
        }
    }

    public Launcher readFrom(CompoundTag compound) {
        this.reelingSpeed = compound.m_128457_("reelingSpeed");
        this.launchVelocity = compound.m_128457_("launchVelocity");
        this.jumpBoostStrength = compound.m_128457_("jumpBoostStrength");
        this.tarzanJumpStrength = compound.m_128457_("tarzanJumpStrength");
        this.shooterWeightFactor = compound.m_128457_("shooterWeightFactor");
        return this;
    }

    public CompoundTag writeTo(CompoundTag compound) {
        compound.m_128350_("reelingSpeed", this.reelingSpeed);
        compound.m_128350_("launchVelocity", this.launchVelocity);
        compound.m_128350_("jumpBoostStrength", this.jumpBoostStrength);
        compound.m_128350_("tarzanJumpStrength", this.tarzanJumpStrength);
        compound.m_128350_("shooterWeightFactor", this.shooterWeightFactor);
        return compound;
    }

    public static class Properties<T extends Properties<T>>
    extends DamageableItem.Properties<T> {
        public float reelingSpeed;
        public float launchVelocity;
        public float jumpBoostStrength = 1.0f;
        public float tarzanJumpStrength = 1.0f;
        public float shooterWeightFactor = 1.0f;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            this.repairMaterial = UnitId.from((String)"string");
        }

        public T reelingSpeed(float value) {
            this.reelingSpeed = value;
            return (T)((Object)((Properties)this.self));
        }

        public T launchVelocity(float value) {
            this.launchVelocity = value;
            return (T)((Object)((Properties)this.self));
        }

        public T jumpBoost(float strength) {
            this.jumpBoostStrength = strength;
            return (T)((Object)((Properties)this.self));
        }

        public T tarzanJump(float strength) {
            this.tarzanJumpStrength = strength;
            return (T)((Object)((Properties)this.self));
        }

        public T shooterWeightFactor(float value) {
            this.shooterWeightFactor = value;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Cooldowns {
        static final int TICKS_MAX_DEFAULT = 10;
        protected final InteractionHand hand;
        protected final Map<HookShot.WatchedBool, Integer> ticksRemain;
        protected final Map<HookShot.WatchedBool, Integer> ticksMax;

        public Cooldowns(InteractionHand hand) {
            this.hand = hand;
            this.ticksRemain = new EnumMap<HookShot.WatchedBool, Integer>(HookShot.WatchedBool.class);
            this.ticksMax = new EnumMap<HookShot.WatchedBool, Integer>(HookShot.WatchedBool.class);
        }

        public void tick(HookShot.WatchedBool key) {
            this.ticksRemain.computeIfPresent(key, (k, ticks) -> ticks > 0 ? ticks - 1 : 0);
        }

        public boolean expired(HookShot.WatchedBool key) {
            return this.ticksRemain(key) == 0;
        }

        public boolean maxxed(HookShot.WatchedBool key) {
            return this.ticksRemain(key) == this.ticksMax(key);
        }

        public int ticksRemain(HookShot.WatchedBool key) {
            return Optional.ofNullable(this.ticksRemain.get((Object)key)).orElse(0);
        }

        public int ticksMax(HookShot.WatchedBool key) {
            return Optional.ofNullable(this.ticksMax.get((Object)key)).orElse(10);
        }

        public void set(HookShot.WatchedBool key, int ticks) {
            if (ticks != 0 && ticks != 10) {
                this.ticksMax.put(key, ticks);
            }
            this.ticksRemain.put(key, Math.max(ticks, 0));
        }

        public void reset(HookShot.WatchedBool key) {
            this.set(key, this.ticksMax(key));
        }

        public void zero(HookShot.WatchedBool key) {
            this.set(key, 0);
        }

        public void tickIfTrueElseZero(HookShot.WatchedBool key, Predicate<HookShot.WatchedBool> predicate) {
            if (predicate.test(key)) {
                this.tick(key);
            } else {
                this.zero(key);
            }
        }
    }

    public static class WatchedStates {
        protected final InteractionHand hand;
        protected final Map<HookShot.WatchedBool, Boolean> bools;

        public WatchedStates(InteractionHand hand) {
            this.hand = hand;
            this.bools = new EnumMap<HookShot.WatchedBool, Boolean>(HookShot.WatchedBool.class);
        }

        public boolean get(HookShot.WatchedBool action) {
            return this.bools.computeIfAbsent(action, a -> false);
        }

        public void updateAndSync(HookShot.WatchedBool action, Function<HookShot.WatchedBool, Boolean> newValueFunc) {
            boolean newValue;
            boolean oldValue = this.get(action);
            if (oldValue != (newValue = newValueFunc.apply(action).booleanValue())) {
                this.bools.put(action, newValue);
                WatchedBoolMsg.sendToServer(this.hand, action, newValue);
            }
        }
    }
}

