/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.BaseProperties;
import com.endertech.minecraft.forge.data.INBTSerializable;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class Rope
implements IHaveConfig,
INBTSerializable<Rope> {
    public static final IntBounds LENGTH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(80));
    public static final FloatBounds WIDTH_BOUNDS = new FloatBounds(Float.valueOf(1.0f), Float.valueOf(10.0f));
    public static final FloatBounds ELASTICITY_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.95f));
    public static final FloatBounds BOUNCE_REDUCTION_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(0.3f));
    public final int segmentsAmount = 16;
    public final ColorARGB color;
    protected int maxLength;
    protected float width;
    protected float elasticity;
    protected final UnitConfig config;

    public Rope(UnitConfig config, Properties<?> props) {
        this.config = config;
        String category = this.getClassCategory();
        this.maxLength = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maxLength", (int)props.maxLength, (IntBounds)LENGTH_BOUNDS, (String)"Defines the maximal rope length.");
        this.width = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"width", (float)props.width, (FloatBounds)WIDTH_BOUNDS, (String)"Defines the rope width.");
        this.elasticity = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"elasticity", (float)props.elasticity, (FloatBounds)ELASTICITY_BOUNDS, (String)"Defines how elastic the rope is.");
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)props.color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public float getWidth() {
        return this.width;
    }

    public float getElasticity() {
        return this.elasticity;
    }

    public float getBounceReduction() {
        return BOUNCE_REDUCTION_BOUNDS.interpolateDown(this.getElasticity()).floatValue();
    }

    public float getTensionForce(float ropeLength, float realDistance) {
        float diff = realDistance - ropeLength;
        float ropeStrength = this.getRopeStrength();
        return diff * ropeStrength;
    }

    public float getRopeStrength() {
        return CommonMath.Interpolation.down((float)this.getElasticity(), (FloatBounds)ELASTICITY_BOUNDS);
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public float getMinLength(@Nullable LivingEntity shooter, @Nullable Entity target) {
        float shooterSize = shooter != null ? Math.max(shooter.m_20205_(), shooter.m_20206_()) : 0.0f;
        float targetSize = target != null ? Math.max(target.m_20205_(), target.m_20206_()) : 0.0f;
        float minLength = shooterSize + targetSize;
        minLength = (float)((double)minLength / 2.0);
        return minLength;
    }

    public FloatBounds getLengthBounds(@Nullable LivingEntity shooter, @Nullable Entity target) {
        float minLength = this.getMinLength(shooter, target);
        return FloatBounds.between((Float)Float.valueOf(minLength), (Float)Float.valueOf(this.getMaxLength()));
    }

    public Rope readFrom(CompoundTag compound) {
        this.maxLength = compound.m_128451_("maxLength");
        this.width = compound.m_128457_("width");
        this.elasticity = compound.m_128457_("elasticity");
        return this;
    }

    public CompoundTag writeTo(CompoundTag compound) {
        compound.m_128405_("maxLength", this.maxLength);
        compound.m_128350_("width", this.width);
        compound.m_128350_("elasticity", this.elasticity);
        return compound;
    }

    public static class Properties<T extends Properties<T>>
    extends BaseProperties<T> {
        public int maxLength;
        public float width;
        public float elasticity;
        public ColorARGB color = ColorARGB.DEFAULT;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        public T maxLength(int value) {
            this.maxLength = value;
            return (T)((Object)((Properties)this.self));
        }

        public T width(float value) {
            this.width = value;
            return (T)((Object)((Properties)this.self));
        }

        public T elasticity(float value) {
            this.elasticity = value;
            return (T)((Object)((Properties)this.self));
        }

        public T color(int argb) {
            this.color = ColorARGB.from((int)argb);
            return (T)((Object)((Properties)this.self));
        }
    }
}

