/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Client.EntityModels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.factionbedrock.aerialhell.Entity.Passive.GlidingTurtleEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GlidingTurtleModel
extends EntityModel<GlidingTurtleEntity> {
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart WingRight;
    private final ModelPart WingLeft;
    private final ModelPart LegFrontRight;
    private final ModelPart LegFrontLeft;
    private final ModelPart LegBackRight;
    private final ModelPart LegBackLeft;
    private boolean isGliding;
    private boolean isChild;

    public GlidingTurtleModel(ModelPart root) {
        this.Head = root.m_171324_("Head");
        this.Body = root.m_171324_("Body");
        this.WingRight = root.m_171324_("WingRight");
        this.WingLeft = root.m_171324_("WingLeft");
        this.LegFrontRight = root.m_171324_("LegFrontRight");
        this.LegFrontLeft = root.m_171324_("LegFrontLeft");
        this.LegBackRight = root.m_171324_("LegBackRight");
        this.LegBackLeft = root.m_171324_("LegBackLeft");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(92, 0).m_171488_(-4.0f, -5.0f, -10.0f, 8.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(92, 16).m_171488_(-4.0f, 1.0f, -10.0f, 8.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-7.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171488_(-12.0f, -17.0f, -9.0f, 24.0f, 4.0f, 25.0f, new CubeDeformation(0.0f)).m_171514_(25, 91).m_171488_(-10.0f, -33.0f, -7.0f, 20.0f, 16.0f, 21.0f, new CubeDeformation(0.0f)).m_171514_(0, 90).m_171488_(-5.0f, -22.0f, -8.0f, 10.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition rightHole_r1 = Body.m_171599_("rightHole_r1", CubeListBuilder.m_171558_().m_171514_(0, 90).m_171480_().m_171488_(-8.0f, -22.0f, -11.0f, 10.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leftHole_r1 = Body.m_171599_("leftHole_r1", CubeListBuilder.m_171558_().m_171514_(0, 90).m_171488_(-2.0f, -22.0f, -11.0f, 10.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition WingRight = partdefinition.m_171599_("WingRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-11.0f, (float)7.0f, (float)3.0f));
        PartDefinition Wing_r1 = WingRight.m_171599_("Wing_r1", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-24.0f, -19.0f, -7.0f, 12.0f, 0.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)11.0f, (float)20.0f, (float)-3.0f, (float)-0.2094f, (float)0.0f, (float)0.0873f));
        PartDefinition WingLeft = partdefinition.m_171599_("WingLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)11.0f, (float)7.0f, (float)3.0f));
        PartDefinition Wing_r2 = WingLeft.m_171599_("Wing_r2", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171480_().m_171488_(12.0f, -19.0f, -7.0f, 12.0f, 0.0f, 18.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-11.0f, (float)20.0f, (float)-3.0f, (float)-0.2094f, (float)0.0f, (float)-0.0873f));
        PartDefinition LegFrontRight = partdefinition.m_171599_("LegFrontRight", CubeListBuilder.m_171558_().m_171514_(0, 112).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)14.0f, (float)-4.0f));
        PartDefinition LegFrontLeft = partdefinition.m_171599_("LegFrontLeft", CubeListBuilder.m_171558_().m_171514_(0, 112).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)14.0f, (float)-4.0f));
        PartDefinition LegBackRight = partdefinition.m_171599_("LegBackRight", CubeListBuilder.m_171558_().m_171514_(0, 112).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)14.0f, (float)10.0f));
        PartDefinition LegBackLeft = partdefinition.m_171599_("LegBackLeft", CubeListBuilder.m_171558_().m_171514_(0, 112).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)14.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(GlidingTurtleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.isGliding = entity.isGliding();
        this.isChild = entity.m_6162_();
        this.Head.f_104204_ = netHeadYaw / 57.29578f;
        this.Head.f_104203_ = headPitch / 57.29578f;
        this.animateRightLeg(this.LegFrontRight, limbSwing, limbSwingAmount);
        this.animateRightLeg(this.LegBackRight, limbSwing, limbSwingAmount);
        this.animateLeftLeg(this.LegFrontLeft, limbSwing, limbSwingAmount);
        this.animateLeftLeg(this.LegBackLeft, limbSwing, limbSwingAmount);
        if (this.isGliding) {
            this.WingRight.f_104205_ = 0.0f;
            this.WingLeft.f_104205_ = 0.0f;
        } else {
            this.WingRight.f_104205_ = -45.0f;
            this.WingLeft.f_104205_ = 45.0f;
        }
    }

    private void animateLeftLeg(ModelPart model, float limbSwing, float limbSwingAmount) {
        model.f_104203_ = -1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        model.f_104204_ = 0.0f;
    }

    private void animateRightLeg(ModelPart model, float limbSwing, float limbSwingAmount) {
        model.f_104203_ = 1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        model.f_104204_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.isChild) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        }
        poseStack.m_85836_();
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.WingRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.WingLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegFrontRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegFrontLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegBackRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegBackLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

