/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Client.EntityModels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.factionbedrock.aerialhell.Entity.Bosses.LilithEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class LilithModel
extends EntityModel<LilithEntity> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart wingRight;
    private final ModelPart wingLeft;
    private final ModelPart legLeft;
    private final ModelPart legRight;
    private final ModelPart armLeft;
    private final ModelPart armRight;

    public LilithModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.wingRight = root.m_171324_("wingRight");
        this.wingLeft = root.m_171324_("wingLeft");
        this.legLeft = root.m_171324_("legLeft");
        this.legRight = root.m_171324_("legRight");
        this.armLeft = root.m_171324_("armLeft");
        this.armRight = root.m_171324_("armRight");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(17, 16).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition wingRight = partdefinition.m_171599_("wingRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)5.0f, (float)2.0f));
        PartDefinition wingRight_r1 = wingRight.m_171599_("wingRight_r1", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-0.5f, -25.0f, 4.0f, 0.0f, 13.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)19.0f, (float)-2.0f, (float)0.2094f, (float)-0.6981f, (float)0.0f));
        PartDefinition wingLeft = partdefinition.m_171599_("wingLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)5.0f, (float)2.0f));
        PartDefinition wingLeft_r1 = wingLeft.m_171599_("wingLeft_r1", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.5f, -25.0f, 4.0f, 0.0f, 13.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)19.0f, (float)-2.0f, (float)0.2094f, (float)0.6981f, (float)0.0f));
        PartDefinition legLeft = partdefinition.m_171599_("legLeft", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition legRight = partdefinition.m_171599_("legRight", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition armLeft = partdefinition.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(41, 16).m_171480_().m_171488_(0.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = partdefinition.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(41, 16).m_171488_(-4.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LilithEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isTransforming()) {
            int i = entity.attackTimer;
            if (i > 0) {
                this.armRight.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)i, (float)10.0f) * 0.5f;
                this.armLeft.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)i, (float)10.0f) * 0.5f;
            } else {
                this.armRight.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount * 0.6f;
                this.armLeft.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount * 0.6f;
            }
        } else {
            this.armRight.f_104203_ = -2.2f;
            this.armLeft.f_104203_ = -2.2f;
        }
        this.head.f_104204_ = netHeadYaw / 57.3f;
        this.head.f_104203_ = headPitch / 57.3f;
        this.legLeft.f_104203_ = -1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.legLeft.f_104204_ = 0.0f;
        this.legRight.f_104203_ = 1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.legRight.f_104204_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.wingRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.wingLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.armLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.armRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

