/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Client.EntityModels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.factionbedrock.aerialhell.Entity.Passive.SandySheepEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SandySheepModel
extends EntityModel<SandySheepEntity> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightFrontLegCoat;
    private final ModelPart rightBackLeg;
    private final ModelPart rightBackLegCoat;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftFrontLegCoat;
    private final ModelPart leftBackLeg;
    private final ModelPart leftBackLegCoat;
    private final ModelPart headCoat;
    private final ModelPart bodyCoat;
    private boolean hasWool;
    private boolean isChild;

    public SandySheepModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.rightFrontLegCoat = root.m_171324_("rightFrontLegCoat");
        this.rightBackLeg = root.m_171324_("rightBackLeg");
        this.rightBackLegCoat = root.m_171324_("rightBackLegCoat");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
        this.leftFrontLegCoat = root.m_171324_("leftFrontLegCoat");
        this.leftBackLeg = root.m_171324_("leftBackLeg");
        this.leftBackLegCoat = root.m_171324_("leftBackLegCoat");
        this.headCoat = root.m_171324_("headCoat");
        this.bodyCoat = root.m_171324_("bodyCoat");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -4.0f, -7.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-8.0f));
        PartDefinition snout_r1 = head.m_171599_("snout_r1", CubeListBuilder.m_171558_().m_171514_(28, 8).m_171488_(-1.0f, -18.01f, -16.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)8.0f, (float)0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(80, 42).m_171488_(-3.5f, -17.0f, -8.5f, 8.0f, 6.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(-1.0f, -4.0f, -2.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)-6.0f));
        PartDefinition rightFrontLegCoat = partdefinition.m_171599_("rightFrontLegCoat", CubeListBuilder.m_171558_().m_171514_(12, 46).m_171480_().m_171488_(-3.0f, -5.0f, -5.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(-1.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)-6.0f));
        PartDefinition rightBackLeg = partdefinition.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(-1.0f, -4.0f, -1.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)5.0f));
        PartDefinition rightBackLegCoat = partdefinition.m_171599_("rightBackLegCoat", CubeListBuilder.m_171558_().m_171514_(12, 46).m_171480_().m_171488_(-3.0f, -5.0f, -3.5f, 7.0f, 10.0f, 8.0f, new CubeDeformation(-1.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)5.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171480_().m_171488_(-2.0f, -4.0f, -2.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)-6.0f));
        PartDefinition leftFrontLegCoat = partdefinition.m_171599_("leftFrontLegCoat", CubeListBuilder.m_171558_().m_171514_(12, 46).m_171488_(-4.0f, -5.0f, -5.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(-1.0f)), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)-6.0f));
        PartDefinition leftBackLeg = partdefinition.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171480_().m_171488_(-2.0f, -4.0f, -1.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)5.0f));
        PartDefinition leftBackLegCoat = partdefinition.m_171599_("leftBackLegCoat", CubeListBuilder.m_171558_().m_171514_(12, 46).m_171488_(-4.0f, -5.0f, -3.5f, 7.0f, 10.0f, 8.0f, new CubeDeformation(-1.0f)), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)5.0f));
        PartDefinition headCoat = partdefinition.m_171599_("headCoat", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-3.0f, -5.0f, -8.0f, 7.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-8.0f));
        PartDefinition bodyCoat = partdefinition.m_171599_("bodyCoat", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-4.5f, -18.0f, -11.0f, 10.0f, 10.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(SandySheepEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.hasWool = entity.hasWool();
        this.isChild = entity.m_6162_();
        this.head.f_104204_ = netHeadYaw / 57.29578f;
        this.head.f_104203_ = headPitch / 57.29578f;
        this.headCoat.f_104204_ = netHeadYaw / 57.29578f;
        this.headCoat.f_104203_ = headPitch / 57.29578f;
        this.animateRightLeg(this.rightFrontLeg, limbSwing, limbSwingAmount);
        this.animateRightLeg(this.rightBackLeg, limbSwing, limbSwingAmount);
        this.animateRightLeg(this.rightFrontLegCoat, limbSwing, limbSwingAmount);
        this.animateRightLeg(this.rightBackLegCoat, limbSwing, limbSwingAmount);
        this.animateLeftLeg(this.leftFrontLeg, limbSwing, limbSwingAmount);
        this.animateLeftLeg(this.leftBackLeg, limbSwing, limbSwingAmount);
        this.animateLeftLeg(this.leftFrontLegCoat, limbSwing, limbSwingAmount);
        this.animateLeftLeg(this.leftBackLegCoat, limbSwing, limbSwingAmount);
    }

    private void animateLeftLeg(ModelPart model, float limbSwing, float limbSwingAmount) {
        model.f_104203_ = -1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        model.f_104204_ = 0.0f;
    }

    private void animateRightLeg(ModelPart model, float limbSwing, float limbSwingAmount) {
        model.f_104203_ = 1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        model.f_104204_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.isChild) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        }
        poseStack.m_85836_();
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightBackLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftBackLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.hasWool) {
            this.rightFrontLegCoat.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightBackLegCoat.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftFrontLegCoat.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftBackLegCoat.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.headCoat.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.bodyCoat.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }
}

