/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Client.EntityRender;

import fr.factionbedrock.aerialhell.Client.EntityModels.AerialHellModelLayers;
import fr.factionbedrock.aerialhell.Client.EntityModels.ChestMimicModel;
import fr.factionbedrock.aerialhell.Entity.AbstractChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.AerialTreeChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.CopperPineChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.GoldenBeechChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.SkyCactusFiberChestMimicEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChestMimicRender<T extends AbstractChestMimicEntity>
extends MobRenderer<T, ChestMimicModel<T>> {
    private static final ResourceLocation OVERWORLD_TEXTURE = new ResourceLocation("aerialhell", "textures/entity/chest_mimic/overworld.png");
    private static final ResourceLocation AERIAL_TREE_TEXTURE = new ResourceLocation("aerialhell", "textures/entity/chest_mimic/aerial_tree.png");
    private static final ResourceLocation SKY_CACTUS_FIBER_TEXTURE = new ResourceLocation("aerialhell", "textures/entity/chest_mimic/sky_cactus_fiber.png");
    private static final ResourceLocation GOLDEN_BEECH_TEXTURE = new ResourceLocation("aerialhell", "textures/entity/chest_mimic/golden_beech.png");
    private static final ResourceLocation COPPER_PINE_TEXTURE = new ResourceLocation("aerialhell", "textures/entity/chest_mimic/copper_pine.png");

    public ChestMimicRender(EntityRendererProvider.Context context) {
        super(context, new ChestMimicModel(context.m_174023_(AerialHellModelLayers.CHEST_MIMIC)), 1.0f);
    }

    public ResourceLocation getTextureLocation(T mimic) {
        if (mimic instanceof AerialTreeChestMimicEntity) {
            return AERIAL_TREE_TEXTURE;
        }
        if (mimic instanceof GoldenBeechChestMimicEntity) {
            return GOLDEN_BEECH_TEXTURE;
        }
        if (mimic instanceof SkyCactusFiberChestMimicEntity) {
            return SKY_CACTUS_FIBER_TEXTURE;
        }
        if (mimic instanceof CopperPineChestMimicEntity) {
            return COPPER_PINE_TEXTURE;
        }
        return OVERWORLD_TEXTURE;
    }
}

