/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Client.World;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class AerialHellDimensionSkyRenderer {
    private static VertexBuffer starVBO;
    private static final ResourceLocation AERIAL_HELL_SUN_LOCATION;
    private static final ResourceLocation AERIAL_HELL_MOON_PHASES_LOCATION;

    public AerialHellDimensionSkyRenderer() {
        this.generateStars();
    }

    private void generateStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (starVBO != null) {
            starVBO.close();
        }
        starVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.renderStars(bufferbuilder);
        starVBO.m_85921_();
        starVBO.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    public static boolean render(ClientLevel level, float partialTicks, PoseStack poseStackIn, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        setupFog.run();
        Vec3 skyColorVec = level.m_171660_(camera.m_90583_(), partialTicks);
        float x = (float)skyColorVec.f_82479_;
        float y = (float)skyColorVec.f_82480_;
        float z = (float)skyColorVec.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)x, (float)y, (float)z, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        levelRenderer.f_109472_.m_85921_();
        levelRenderer.f_109472_.m_253207_(poseStackIn.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStackIn.m_85836_();
        poseStackIn.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStackIn.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTicks) * 360.0f));
        float moonBrightness = Math.min(level.m_104811_(partialTicks) * 2.0f, 1.0f);
        float sunBrightness = 1.0f - moonBrightness;
        Matrix4f matrix4f1 = poseStackIn.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)sunBrightness);
        float f12 = 30.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AERIAL_HELL_SUN_LOCATION);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)moonBrightness);
        f12 = 20.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AERIAL_HELL_MOON_PHASES_LOCATION);
        int k = level.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        float starsBrightness = level.m_104811_(partialTicks);
        if (starsBrightness > 0.0f) {
            RenderSystem.setShaderColor((float)starsBrightness, (float)starsBrightness, (float)starsBrightness, (float)starsBrightness);
            FogRenderer.m_109017_();
            starVBO.m_85921_();
            starVBO.m_253207_(poseStackIn.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            setupFog.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStackIn.m_85849_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        return true;
    }

    private BufferBuilder.RenderedBuffer renderStars(BufferBuilder buffer) {
        RandomSource randomsource = RandomSource.m_216335_((long)10842L);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 4000; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                buffer.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return buffer.m_231175_();
    }

    static {
        AERIAL_HELL_SUN_LOCATION = new ResourceLocation("aerialhell", "textures/environment/aerial_hell_sun.png");
        AERIAL_HELL_MOON_PHASES_LOCATION = new ResourceLocation("aerialhell", "textures/environment/aerial_hell_moon_phases.png");
    }
}

