/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity;

import fr.factionbedrock.aerialhell.Entity.AerialHellHostileEntity;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public abstract class AbstractElementSpiritEntity
extends AerialHellHostileEntity {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(AbstractElementSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int tickStartAttacking;

    public AbstractElementSpiritEntity(EntityType<? extends AbstractElementSpiritEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22281_, 0.5);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            this.setAttacking();
            this.tickStartAttacking = this.f_19797_;
        }
        return flag;
    }

    public void m_8119_() {
        if (this.isAttacking() && this.f_19797_ > this.tickStartAttacking + 3) {
            this.attackSuicide();
        }
        super.m_8119_();
    }

    public void attackSuicide() {
        this.m_5496_(this.m_5592_(), 1.5f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
        this.spawnParticle();
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(4.0), EntitySelector.m_20410_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)4.0));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            this.applyEffect(entity);
        }
        this.m_146870_();
    }

    public void spawnParticle() {
        for (int i = 0; i < 30; ++i) {
            double d0 = (this.f_19796_.m_188583_() - 0.5) * 0.02;
            double d1 = (this.f_19796_.m_188583_() - 0.5) * 0.02;
            double d2 = (this.f_19796_.m_188583_() - 0.5) * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)this.getParticleToSpawn(), this.m_20165_(1.0) + d0 * 10.0, this.m_20187_() + d1 * 10.0, this.m_20262_(1.0) + d2 * 10.0, d0, d1, d2);
        }
    }

    public abstract void applyEffect(Entity var1);

    public abstract SimpleParticleType getParticleToSpawn();

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Disappearing", this.isAttacking());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128471_("Disappearing")) {
            this.setAttacking();
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking() {
        this.f_19804_.m_135381_(ATTACKING, (Object)true);
    }
}

