/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Bosses;

import fr.factionbedrock.aerialhell.Block.AerialHellBookshelfBlock;
import fr.factionbedrock.aerialhell.Block.AerialHellStandingSignBlock;
import fr.factionbedrock.aerialhell.Block.AerialHellTorchBlock;
import fr.factionbedrock.aerialhell.Block.AerialHellWallTorchBlock;
import fr.factionbedrock.aerialhell.Block.StellarGrassBlock;
import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveMeleeAttackGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveNearestAttackableTargetGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveWaterAvoidingRandomWalkingGoal;
import fr.factionbedrock.aerialhell.Entity.AI.GhastLikeGoals;
import fr.factionbedrock.aerialhell.Entity.AI.SummonThreeEntitiesGoal;
import fr.factionbedrock.aerialhell.Entity.AbstractBossEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.MudCycleMageEntity;
import fr.factionbedrock.aerialhell.Entity.Projectile.ShadowProjectileEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellMobEffects;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Registry.Entities.AerialHellEntities;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellDimensions;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LilithEntity
extends AbstractBossEntity {
    public int attackTimer = 0;
    private static final EntityDataAccessor<Boolean> IS_TRANSFORMING = SynchedEntityData.m_135353_(LilithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_TRANSFORMED = SynchedEntityData.m_135353_(LilithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeSinceTransforming = 0;
    private final int transformationTime = 160;

    public LilithEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_20916_ = 0;
        this.bossInfo.m_6451_(BossEvent.BossBarColor.PURPLE);
        this.bossInfo.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(2, new ActiveNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new LilithMeleeAttackGoal(this, 1.25, false));
        this.f_21345_.m_25352_(2, (Goal)new LilithSummonShadowFlyingSkullGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new LilithWaterAvoidingRandomWalkingGoal(this, 0.6));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, MudCycleMageEntity.class, true));
        this.f_21345_.m_25352_(2, (Goal)new ShadowProjectileAttackGoal(this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 20.0);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity immediateSourceEntity = source.m_7640_();
        Entity trueSourceEntity = source.m_7639_();
        if (this.isTransforming() && !source.m_19390_() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if ((double)this.m_21233_() < 2.5 * (double)this.m_21223_() && immediateSourceEntity instanceof AbstractArrow) {
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (!(!flag || !(trueSourceEntity instanceof LivingEntity) || immediateSourceEntity instanceof AbstractArrow || trueSourceEntity instanceof Player && ((Player)trueSourceEntity).m_7500_())) {
            this.m_6710_((LivingEntity)trueSourceEntity);
        }
        return flag;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_TRANSFORMING, (Object)false);
        this.f_19804_.m_135372_(IS_TRANSFORMED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("timeTransforming", (short)this.timeSinceTransforming);
        compound.m_128379_("isTransforming", this.isTransforming());
        if (((Boolean)this.f_19804_.m_135370_(IS_TRANSFORMED)).booleanValue()) {
            compound.m_128379_("isTransformed", true);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("timeTransforming", 99)) {
            this.timeSinceTransforming = compound.m_128448_("timeTransforming");
        }
        this.setTransforming(compound.m_128471_("isTransforming"));
        this.f_19804_.m_135381_(IS_TRANSFORMED, (Object)compound.m_128471_("isTransformed"));
    }

    public boolean isTransforming() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRANSFORMING);
    }

    public void setTransforming(boolean isTransforming) {
        this.f_19804_.m_135381_(IS_TRANSFORMING, (Object)isTransforming);
    }

    public boolean isTransformed() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRANSFORMED);
    }

    public void setTransformed() {
        this.f_19804_.m_135381_(IS_TRANSFORMED, (Object)true);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public Item getTrophy() {
        return (Item)AerialHellBlocksAndItems.LILITH_TROPHY_ITEM.get();
    }

    @Override
    public void m_8119_() {
        if (this.isActive() && !this.isTransformed() && !this.isTransforming()) {
            this.timeSinceTransforming = 0;
            this.setTransforming(true);
            this.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_LILITH_TRANSFORMATION.get(), 5.0f, 1.0f);
        }
        if (this.isTransforming()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 20, 10, true, false)));
                this.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19606_, 1, 10, true, false)));
            }
            ++this.timeSinceTransforming;
            int i = 0;
            while ((double)i < 10.0 + (double)this.timeSinceTransforming / 1.5) {
                if (this.m_9236_().m_46472_() == AerialHellDimensions.AERIAL_HELL_DIMENSION) {
                    this.transformRandomBlock();
                }
                ++i;
            }
            if (this.timeSinceTransforming >= 160) {
                this.transform();
                this.setTransforming(false);
                if (this.m_9236_().m_46472_() == AerialHellDimensions.AERIAL_HELL_DIMENSION) {
                    this.transformAllBlocks();
                }
                this.timeSinceTransforming = 0;
            }
            if (this.timeSinceTransforming > 12) {
                List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(20.0), EntitySelector.m_20410_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)15.0));
                for (Entity entity : nearbyEntities) {
                    boolean creaOrSpecPlayer;
                    boolean bl = creaOrSpecPlayer = entity instanceof Player && (((Player)entity).m_5833_() || ((Player)entity).m_7500_());
                    if (!(entity instanceof LivingEntity) || creaOrSpecPlayer) continue;
                    this.dragEntity(entity);
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 40, 0));
                }
                if (this.m_9236_().m_5776_()) {
                    for (int i2 = 0; i2 < 5; ++i2) {
                        double rand = this.f_19796_.m_188501_() * 2.0f;
                        double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() - 0.5f) * rand;
                        double y = this.m_20191_().f_82289_ + rand + 0.5;
                        double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() - 0.5f) * rand;
                        double dx = (this.f_19796_.m_188501_() - 0.5f) / 10.0f;
                        double dz = (this.f_19796_.m_188501_() - 0.5f) / 10.0f;
                        this.m_9236_().m_7106_((ParticleOptions)AerialHellParticleTypes.SHADOW_PARTICLE.get(), x, y, z, dx, 0.0, dz);
                    }
                }
            }
        }
        super.m_8119_();
    }

    private void transformRandomBlock() {
        int maxHorizontalDistance = 14;
        int maxVerticalDistance = 10;
        int x = this.f_19796_.m_188503_(2 * maxHorizontalDistance) - maxHorizontalDistance;
        int y = this.f_19796_.m_188503_(2 * maxVerticalDistance) - maxVerticalDistance;
        int z = this.f_19796_.m_188503_(2 * maxHorizontalDistance) - maxHorizontalDistance;
        BlockPos transformationPos = new BlockPos((Vec3i)this.m_20183_().m_121955_(new Vec3i(x, y, z)));
        if (this.m_9236_().m_8055_(transformationPos).m_204336_(AerialHellTags.Blocks.LILITH_TRANSFORMABLE)) {
            this.transformBlock(transformationPos);
        }
    }

    private void transformAllBlocks() {
        int maxHorizontalDistance = 12;
        int maxVerticalDistance = 10;
        for (int x = -maxHorizontalDistance; x < maxHorizontalDistance; ++x) {
            for (int y = -maxVerticalDistance; y < maxVerticalDistance; ++y) {
                for (int z = -maxHorizontalDistance; z < maxHorizontalDistance; ++z) {
                    BlockPos transformationPos = new BlockPos((Vec3i)this.m_20183_().m_121955_(new Vec3i(x, y, z)));
                    if (!this.m_9236_().m_8055_(transformationPos).m_204336_(AerialHellTags.Blocks.LILITH_TRANSFORMABLE)) continue;
                    this.transformBlock(transformationPos);
                }
            }
        }
    }

    private void transformBlock(BlockPos pos) {
        if (this.m_9236_().m_8055_(pos).m_60734_() instanceof DoorBlock) {
            DoubleBlockHalf half = (DoubleBlockHalf)this.m_9236_().m_8055_(pos).m_61143_((Property)DoorBlock.f_52730_);
            if (half == DoubleBlockHalf.LOWER) {
                this.m_9236_().m_46961_(pos, false);
                this.m_9236_().m_46961_(pos.m_7494_(), false);
            } else {
                this.m_9236_().m_46961_(pos.m_7495_(), false);
                this.m_9236_().m_46961_(pos, false);
            }
        } else {
            this.m_9236_().m_46597_(pos, this.getEquivalentShadowBlockstate(this.m_9236_().m_8055_(pos)));
        }
    }

    private BlockState getEquivalentShadowBlockstate(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof AerialHellTorchBlock) {
            if (block instanceof AerialHellWallTorchBlock) {
                return (BlockState)((Block)AerialHellBlocksAndItems.SHADOW_WALL_TORCH.get()).m_49966_().m_61124_((Property)AerialHellWallTorchBlock.HORIZONTAL_FACING, (Comparable)((Direction)blockState.m_61143_((Property)AerialHellWallTorchBlock.HORIZONTAL_FACING)));
            }
            return ((Block)AerialHellBlocksAndItems.SHADOW_TORCH.get()).m_49966_();
        }
        if (blockState.m_204336_(AerialHellTags.Blocks.SOLID_ETHER)) {
            return ((Block)AerialHellBlocksAndItems.PURPLE_SOLID_ETHER.get()).m_49966_();
        }
        if (block == AerialHellBlocksAndItems.CRYSTAL_BLOCK.get()) {
            return ((Block)AerialHellBlocksAndItems.SHADOW_CRYSTAL_BLOCK.get()).m_49966_();
        }
        if (block == AerialHellBlocksAndItems.VIBRANT_SKY_CACTUS_FIBER_LANTERN.get()) {
            return ((Block)AerialHellBlocksAndItems.GIANT_CORTINARIUS_VIOLACEUS_LIGHT.get()).m_49966_();
        }
        if (block instanceof StellarGrassBlock) {
            return ((Block)AerialHellBlocksAndItems.SHADOW_GRASS_BLOCK.get()).m_49966_();
        }
        if (block == AerialHellBlocksAndItems.STELLAR_GRASS.get()) {
            return ((Block)AerialHellBlocksAndItems.SHADOW_GRASS.get()).m_49966_();
        }
        if (block == AerialHellBlocksAndItems.STELLAR_GRASS_BALL.get()) {
            return ((Block)AerialHellBlocksAndItems.SHADOW_GRASS_BALL.get()).m_49966_();
        }
        if (block instanceof LanternBlock) {
            return (BlockState)((Block)AerialHellBlocksAndItems.SHADOW_LANTERN.get()).m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)((Boolean)blockState.m_61143_((Property)LanternBlock.f_153459_)));
        }
        if (block instanceof ChainBlock) {
            return (BlockState)((ChainBlock)AerialHellBlocksAndItems.SHADOW_CHAIN.get()).m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)((Direction.Axis)blockState.m_61143_((Property)ChainBlock.f_55923_)));
        }
        if (block instanceof IronBarsBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((IronBarsBlock)AerialHellBlocksAndItems.SHADOW_BARS.get()).m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)((Boolean)blockState.m_61143_((Property)IronBarsBlock.f_52309_)))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)((Boolean)blockState.m_61143_((Property)IronBarsBlock.f_52311_)))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)((Boolean)blockState.m_61143_((Property)IronBarsBlock.f_52312_)))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)((Boolean)blockState.m_61143_((Property)IronBarsBlock.f_52310_)));
        }
        if (block == AerialHellBlocksAndItems.LAPIS_ROBINIA_PLANKS.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_PLANKS.get() || block == AerialHellBlocksAndItems.CHISELED_AERIAL_TREE_PLANKS.get()) {
            return ((Block)AerialHellBlocksAndItems.GRAY_SHROOM_PLANKS.get()).m_49966_();
        }
        if (block == AerialHellBlocksAndItems.GOLDEN_BEECH_PLANKS.get() || block == AerialHellBlocksAndItems.CHISELED_GOLDEN_BEECH_PLANKS.get() || block == Blocks.f_50745_ || block == AerialHellBlocksAndItems.CHISELED_AERIAL_TREE_PLANKS.get()) {
            return ((Block)AerialHellBlocksAndItems.SHADOW_PINE_PLANKS.get()).m_49966_();
        }
        if (block instanceof SaplingBlock) {
            return ((SaplingBlock)AerialHellBlocksAndItems.SHADOW_PINE_SAPLING.get()).m_49966_();
        }
        if (block instanceof LeavesBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.GOLDEN_BEECH_LEAVES.get() || block == Blocks.f_50055_ ? (Block)AerialHellBlocksAndItems.SHADOW_PINE_LEAVES.get() : (Block)AerialHellBlocksAndItems.PURPLE_SHADOW_PINE_LEAVES.get();
            return (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)((Boolean)blockState.m_61143_((Property)LeavesBlock.f_54419_)))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_)));
        }
        if (block instanceof CraftingTableBlock) {
            if (block == AerialHellBlocksAndItems.LAPIS_ROBINIA_CRAFTING_TABLE.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_CRAFTING_TABLE.get()) {
                return ((CraftingTableBlock)AerialHellBlocksAndItems.GRAY_SHROOM_CRAFTING_TABLE.get()).m_49966_();
            }
            return ((CraftingTableBlock)AerialHellBlocksAndItems.SHADOW_PINE_CRAFTING_TABLE.get()).m_49966_();
        }
        if (block instanceof StairBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_STAIRS.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_STAIRS.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_STAIRS.get() : (block == Blocks.f_50284_ ? (Block)AerialHellBlocksAndItems.SMOKY_QUARTZ_STAIRS.get() : (block == Blocks.f_50637_ ? (Block)AerialHellBlocksAndItems.SMOOTH_SMOKY_QUARTZ_STAIRS.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_STAIRS.get()));
            return (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)blockState.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)blockState.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)blockState.m_61143_((Property)StairBlock.f_56843_)));
        }
        if (block instanceof SlabBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_SLAB.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_SLAB.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_SLAB.get() : (block == Blocks.f_50413_ ? (Block)AerialHellBlocksAndItems.SMOKY_QUARTZ_SLAB.get() : (block == Blocks.f_50650_ ? (Block)AerialHellBlocksAndItems.SMOOTH_SMOKY_QUARTZ_SLAB.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_SLAB.get()));
            return (BlockState)newBlock.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)blockState.m_61143_((Property)SlabBlock.f_56353_)));
        }
        if (block instanceof FenceBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_FENCE.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_FENCE.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_FENCE.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_FENCE.get();
            return (BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)FenceBlock.f_52309_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceBlock.f_52309_)))).m_61124_((Property)FenceBlock.f_52310_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceBlock.f_52310_)))).m_61124_((Property)FenceBlock.f_52312_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceBlock.f_52312_)))).m_61124_((Property)FenceBlock.f_52311_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceBlock.f_52311_)));
        }
        if (block instanceof FenceGateBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_GATE.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_GATE.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_GATE.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_GATE.get();
            return (BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)FenceGateBlock.f_54117_)))).m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_)))).m_61124_((Property)FenceGateBlock.f_53342_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53342_)))).m_61124_((Property)FenceGateBlock.f_53343_, (Comparable)((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53343_)));
        }
        if (block instanceof RotatedPillarBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_LOG.get() || block == AerialHellBlocksAndItems.ENCHANTED_LAPIS_ROBINIA_LOG.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_LOG.get() ? (Block)AerialHellBlocksAndItems.GIANT_VERDIGRIS_AGARIC_STEM.get() : (block == AerialHellBlocksAndItems.STRIPPED_LAPIS_ROBINIA_LOG.get() || block == AerialHellBlocksAndItems.STRIPPED_AERIAL_TREE_LOG.get() ? (Block)AerialHellBlocksAndItems.STRIPPED_GIANT_VERDIGRIS_AGARIC_STEM.get() : (block == Blocks.f_50283_ ? (Block)AerialHellBlocksAndItems.SMOKY_QUARTZ_PILLAR.get() : (block == AerialHellBlocksAndItems.STRIPPED_GOLDEN_BEECH_LOG.get() || block == Blocks.f_50009_ || block == Blocks.f_50010_ ? (Block)AerialHellBlocksAndItems.STRIPPED_SHADOW_PINE_LOG.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_LOG.get())));
            return (BlockState)newBlock.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)blockState.m_61143_((Property)RotatedPillarBlock.f_55923_)));
        }
        if (block == Blocks.f_50282_) {
            return ((Block)AerialHellBlocksAndItems.CHISELED_SMOKY_QUARTZ_BLOCK.get()).m_49966_();
        }
        if (block == Blocks.f_50333_) {
            return ((Block)AerialHellBlocksAndItems.SMOKY_QUARTZ_BLOCK.get()).m_49966_();
        }
        if (block == Blocks.f_50714_) {
            return ((Block)AerialHellBlocksAndItems.SMOKY_QUARTZ_BRICKS.get()).m_49966_();
        }
        if (block == Blocks.f_50472_) {
            return ((Block)AerialHellBlocksAndItems.SMOOTH_SMOKY_QUARTZ.get()).m_49966_();
        }
        if (block == AerialHellBlocksAndItems.GIANT_GANODERMA_APPLANATUM_BLOCK.get()) {
            return ((Block)AerialHellBlocksAndItems.GIANT_CORTINARIUS_VIOLACEUS_CAP_BLOCK.get()).m_49966_();
        }
        if (block instanceof AerialHellBookshelfBlock || block == Blocks.f_50078_) {
            if (block == AerialHellBlocksAndItems.LAPIS_ROBINIA_BOOKSHELF.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_BOOKSHELF.get()) {
                return ((Block)AerialHellBlocksAndItems.GRAY_SHROOM_BOOKSHELF.get()).m_49966_();
            }
            return ((Block)AerialHellBlocksAndItems.SHADOW_PINE_BOOKSHELF.get()).m_49966_();
        }
        if (block instanceof TrapDoorBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_TRAPDOOR.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_TRAPDOOR.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_TRAPDOOR.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_TRAPDOOR.get();
            return (BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)((Boolean)blockState.m_61143_((Property)TrapDoorBlock.f_57514_)))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)((Half)blockState.m_61143_((Property)TrapDoorBlock.f_57515_)))).m_61124_((Property)TrapDoorBlock.f_57516_, (Comparable)((Boolean)blockState.m_61143_((Property)TrapDoorBlock.f_57516_)))).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)TrapDoorBlock.f_54117_)));
        }
        if (block instanceof DoorBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_DOOR.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_DOOR.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_DOOR.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_DOOR.get();
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)blockState.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)blockState.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52729_, (Comparable)((Boolean)blockState.m_61143_((Property)DoorBlock.f_52729_)))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)));
        }
        if (block instanceof ButtonBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_BUTTON.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_BUTTON.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_BUTTON.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_BUTTON.get();
            return (BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)ButtonBlock.f_51045_, (Comparable)((Boolean)blockState.m_61143_((Property)ButtonBlock.f_51045_)))).m_61124_((Property)ButtonBlock.f_53179_, (Comparable)((AttachFace)blockState.m_61143_((Property)ButtonBlock.f_53179_)))).m_61124_((Property)ButtonBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)ButtonBlock.f_54117_)));
        }
        if (block instanceof PressurePlateBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_PRESSURE_PLATE.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_PRESSURE_PLATE.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_PRESSURE_PLATE.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_PRESSURE_PLATE.get();
            return (BlockState)newBlock.m_49966_().m_61124_((Property)PressurePlateBlock.f_55249_, (Comparable)((Boolean)blockState.m_61143_((Property)PressurePlateBlock.f_55249_)));
        }
        if (block instanceof ComposterBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_COMPOSTER.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_COMPOSTER.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_COMPOSTER.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_COMPOSTER.get();
            return (BlockState)newBlock.m_49966_().m_61124_((Property)ComposterBlock.f_51913_, (Comparable)((Integer)blockState.m_61143_((Property)ComposterBlock.f_51913_)));
        }
        if (block instanceof SignBlock) {
            Block newBlock = block == AerialHellBlocksAndItems.LAPIS_ROBINIA_STANDING_SIGN.get() || block == AerialHellBlocksAndItems.AERIAL_TREE_STANDING_SIGN.get() ? (Block)AerialHellBlocksAndItems.GRAY_SHROOM_STANDING_SIGN.get() : (Block)AerialHellBlocksAndItems.SHADOW_PINE_STANDING_SIGN.get();
            return (BlockState)newBlock.m_49966_().m_61124_((Property)AerialHellStandingSignBlock.f_56987_, (Comparable)((Integer)blockState.m_61143_((Property)StandingSignBlock.f_56987_)));
        }
        return ((Block)AerialHellBlocksAndItems.SHADOW_CATACOMBS_BRICKS.get()).m_49966_();
    }

    public void m_8107_() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        super.m_8107_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_7327_(Entity target) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean flag = super.m_7327_(target);
        if (flag && target instanceof LivingEntity && !EntityHelper.isLivingEntityShadowImmune((LivingEntity)target)) {
            ((LivingEntity)target).m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 40, 0));
        }
        this.m_5496_(SoundEvents.f_12361_, 1.0f, 0.5f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else {
            super.m_7822_(id);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LILITH_HURT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LILITH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LILITH_DEATH.get();
    }

    public void m_8032_() {
        if (!this.isTransforming()) {
            super.m_8032_();
        }
    }

    private void dragEntity(Entity entityIn) {
        double factor = 0.2 / (double)Math.max(5.0f, this.m_20270_(entityIn));
        Vec3 toGod = new Vec3(this.m_20185_() - entityIn.m_20185_(), this.m_20186_() - entityIn.m_20186_(), this.m_20189_() - entityIn.m_20189_()).m_82542_(factor, factor, factor);
        entityIn.m_20256_(entityIn.m_20184_().m_82549_(toGod.m_82542_(factor, factor, factor)));
    }

    private void transform() {
        this.setTransformed();
        this.spawnTransformationParticle();
    }

    public void spawnTransformationParticle() {
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 30; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)AerialHellParticleTypes.SHADOW_PARTICLE.get(), this.m_20208_(1.0) - d0 * 10.0, this.m_20187_() - d1 * 10.0, this.m_20262_(1.0) - d2 * 10.0, 2.0 * d0, d1, 2.0 * d2);
            }
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)20);
        }
    }

    public boolean isHealthMatchToShootShadowProjectile() {
        return this.m_21223_() * 2.0f < this.m_21233_();
    }

    public boolean isHealthMatchToSummonFlyingSkulls() {
        return (double)this.m_21233_() > (2.5 - (double)this.getDifficulty() / 6.0) * (double)this.m_21223_();
    }

    public static class LilithMeleeAttackGoal
    extends ActiveMeleeAttackGoal {
        public LilithMeleeAttackGoal(LilithEntity godIn, double speedIn, boolean useLongMemory) {
            super(godIn, speedIn, useLongMemory);
        }

        @Override
        public boolean m_8036_() {
            return !((LilithEntity)this.activableGoalOwner).isTransforming() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return !((LilithEntity)this.activableGoalOwner).isTransforming() && super.m_8045_();
        }
    }

    public static class LilithSummonShadowFlyingSkullGoal
    extends SummonThreeEntitiesGoal {
        public LilithSummonShadowFlyingSkullGoal(LilithEntity entity) {
            super((Mob)entity, 0.2);
        }

        public LilithEntity getLilithGoalOwner() {
            return (LilithEntity)this.getGoalOwner();
        }

        @Override
        public boolean m_8036_() {
            LilithEntity lilith = this.getLilithGoalOwner();
            return super.m_8036_() && lilith.isHealthMatchToSummonFlyingSkulls() && lilith.isActive();
        }

        @Override
        public Entity createEntitiy(Level level) {
            return ((EntityType)AerialHellEntities.SHADOW_FLYING_SKULL.get()).m_20615_(this.getGoalOwner().m_9236_());
        }

        @Override
        protected void setEntityPosToSummonPos(Entity entity) {
            entity.m_6034_(this.getGoalOwner().m_20185_(), this.getGoalOwner().m_20186_() + 1.0, this.getGoalOwner().m_20189_());
        }

        @Override
        protected int getSummonTimerTargetValue() {
            int difficulty = this.getLilithGoalOwner().getDifficulty();
            return switch (difficulty) {
                default -> 180;
                case 1 -> 130;
                case 2 -> 115;
                case 3 -> 100;
                case 4 -> 80;
                case 5 -> 60;
                case 6 -> 50;
            };
        }
    }

    public static class LilithWaterAvoidingRandomWalkingGoal
    extends ActiveWaterAvoidingRandomWalkingGoal {
        public LilithWaterAvoidingRandomWalkingGoal(LilithEntity god, double speedIn) {
            super(god, speedIn);
        }

        @Override
        public boolean m_8036_() {
            return !((LilithEntity)this.activableGoalOwner).isTransforming() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return !((LilithEntity)this.activableGoalOwner).isTransforming() && super.m_8045_();
        }
    }

    public static class ShadowProjectileAttackGoal
    extends GhastLikeGoals.ShootProjectileGoal {
        public ShadowProjectileAttackGoal(LilithEntity entity) {
            super((Mob)entity);
        }

        @Override
        public boolean m_8036_() {
            LilithEntity lilith = (LilithEntity)this.getParentEntity();
            if (!lilith.isActive()) {
                return false;
            }
            LivingEntity target = lilith.m_5448_();
            return super.m_8036_() && lilith.isHealthMatchToShootShadowProjectile() && target.m_6084_() && lilith.m_6779_(target);
        }

        @Override
        public Projectile createProjectile(Level level, LivingEntity shooter, double accX, double accY, double accZ) {
            return new ShadowProjectileEntity(level, shooter, accX, accY, accZ, 0.25f + shooter.m_217043_().m_188501_(), 0.0f);
        }

        @Override
        public int getShootTimeInterval() {
            int difficulty = ((LilithEntity)this.getParentEntity()).getDifficulty();
            if (difficulty == 0) {
                difficulty = 1;
            }
            return 90 / difficulty + (int)(this.getParentEntity().m_217043_().m_188501_() * 40.0f);
        }

        @Override
        public int getShootDelay() {
            return 0;
        }

        @Override
        public boolean doesShootTimeDecreaseWhenTargetOutOfSight() {
            return false;
        }

        @Override
        public double getYProjectileOffset() {
            return 0.5;
        }

        @Override
        protected void setAttacking(boolean bool) {
        }

        @Override
        public SoundEvent getShootSound() {
            return null;
        }
    }
}

