/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Bosses;

import fr.factionbedrock.aerialhell.Entity.AI.ActiveLookAtPlayerGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveMeleeAttackGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveNearestAttackableTargetGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveRandomLookAroundGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveWaterAvoidingRandomWalkingGoal;
import fr.factionbedrock.aerialhell.Entity.AI.GhastLikeGoals;
import fr.factionbedrock.aerialhell.Entity.AbstractBossEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.ChainedGodEntity;
import fr.factionbedrock.aerialhell.Entity.Projectile.LunaticProjectileEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LunaticPriestEntity
extends AbstractBossEntity {
    public int attackTimer;
    public static final EntityDataAccessor<Boolean> SECOND_PHASE = SynchedEntityData.m_135353_(LunaticPriestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LunaticPriestEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        if (this.m_21223_() >= this.getMaxHealthForPhase2()) {
            this.updateToPhase1();
        } else {
            this.updateToPhase2();
        }
        this.attackTimer = 0;
        this.bossInfo.m_6451_(BossEvent.BossBarColor.YELLOW);
        this.bossInfo.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new PriestRandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new GhastLikeGoals.LookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new PriestLookRandomlyGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new PriestWaterAvoidingRandomWalkingGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new ActiveLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new LunaticProjectileAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ActiveMeleeAttackGoal(this, 1.25, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ActiveNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, ChainedGodEntity.class, 6.0f, 1.0, 1.2));
    }

    public float getMaxHealthForPhase2() {
        return this.m_21233_() / 2.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SECOND_PHASE, (Object)false);
    }

    @Override
    public void setActive(boolean isActive) {
        super.setActive(isActive);
        if (!isActive) {
            this.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19591_, 120, 2, true, false)));
        }
    }

    public boolean isInPhase1() {
        return (Boolean)this.f_19804_.m_135370_(SECOND_PHASE) == false;
    }

    public boolean isInPhase2() {
        return (Boolean)this.f_19804_.m_135370_(SECOND_PHASE);
    }

    public boolean shouldUpdateToPhase1() {
        return this.m_21223_() >= this.getMaxHealthForPhase2() && this.isInPhase2();
    }

    public boolean shouldUpdateToPhase2() {
        return this.m_21223_() < this.getMaxHealthForPhase2() && this.isInPhase1();
    }

    private void updateToPhase1() {
        this.f_19804_.m_135381_(SECOND_PHASE, (Object)false);
        this.f_21342_ = new GhastLikeGoals.MoveHelperController((Mob)this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, 2.0, 0.0));
    }

    private void updateToPhase2() {
        this.f_19804_.m_135381_(SECOND_PHASE, (Object)true);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19591_, 120, 2, true, false)));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean wasActive = this.isActive();
        boolean flag = super.m_6469_(source, amount);
        if (flag && source.m_7639_() instanceof LivingEntity && (!(source.m_7639_() instanceof Player) || !((Player)source.m_7639_()).m_7500_())) {
            this.m_6710_((LivingEntity)source.m_7639_());
        }
        if (!wasActive) {
            this.timeWithoutAnyTarget = 0;
            this.updateToPhase1();
        }
        return flag;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22278_, 0.05).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 7.0);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_7327_(Entity attackedEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = attackedEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            attackedEntity.m_20334_(attackedEntity.m_20184_().f_82479_, (double)0.4f, attackedEntity.m_20184_().f_82481_);
            this.m_19970_((LivingEntity)this, attackedEntity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public Item getTrophy() {
        return (Item)AerialHellBlocksAndItems.LUNAR_PRIEST_TROPHY_ITEM.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.shouldUpdateToPhase1() && this.isActive() && this.timeWithoutAnyTarget == 0) {
            this.updateToPhase1();
        }
        if (this.shouldUpdateToPhase2() && this.isActive() && this.timeWithoutAnyTarget == 0) {
            this.updateToPhase2();
        }
        if (this.timeWithoutAnyTarget > 0 && this.isInPhase1()) {
            this.updateToPhase2();
        }
    }

    public void m_8107_() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        super.m_8107_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.isInPhase1()) {
            return false;
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isInPhase1()) {
            if (this.isActive()) {
                if (this.m_20069_()) {
                    this.m_19920_(0.02f, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
                } else if (this.m_20077_()) {
                    this.m_19920_(0.02f, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                } else {
                    BlockPos ground = new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
                    float f = 0.91f;
                    if (this.m_20096_()) {
                        f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                    }
                    float f1 = 0.16277137f / (f * f * f);
                    f = 0.91f;
                    if (this.m_20096_()) {
                        f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                    }
                    this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_((double)f));
                }
                this.m_267651_(false);
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6147_() {
        if (this.isInPhase1() && this.isActive()) {
            return false;
        }
        return super.m_6147_();
    }

    public float getShootVelocityInaccuracy() {
        return this.isInPhase1() ? 0.0f : 0.3f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LUNATIC_PRIEST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LUNATIC_PRIEST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LUNATIC_PRIEST_DEATH.get();
    }

    protected float m_6121_() {
        return 2.5f;
    }

    static class PriestRandomFlyGoal
    extends GhastLikeGoals.RandomFlyGoal {
        public PriestRandomFlyGoal(LunaticPriestEntity priestIn) {
            super((Mob)priestIn);
        }

        @Override
        public boolean m_8036_() {
            LunaticPriestEntity priest = (LunaticPriestEntity)this.getParentEntity();
            if (!priest.isActive() || priest.isInPhase2()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    public static class PriestLookRandomlyGoal
    extends ActiveRandomLookAroundGoal {
        public PriestLookRandomlyGoal(LunaticPriestEntity priestIn) {
            super(priestIn);
        }

        @Override
        public boolean m_8036_() {
            return ((LunaticPriestEntity)this.activableGoalOwner).isInPhase2() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return ((LunaticPriestEntity)this.activableGoalOwner).isInPhase2() && super.m_8045_();
        }
    }

    public static class PriestWaterAvoidingRandomWalkingGoal
    extends ActiveWaterAvoidingRandomWalkingGoal {
        public PriestWaterAvoidingRandomWalkingGoal(LunaticPriestEntity priestIn, double speedIn) {
            super(priestIn, speedIn);
        }

        @Override
        public boolean m_8036_() {
            return ((LunaticPriestEntity)this.activableGoalOwner).isInPhase2() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return ((LunaticPriestEntity)this.activableGoalOwner).isInPhase2() && super.m_8045_();
        }
    }

    public static class LunaticProjectileAttackGoal
    extends GhastLikeGoals.ShootProjectileGoal {
        public LunaticProjectileAttackGoal(LunaticPriestEntity entity) {
            super((Mob)entity);
        }

        @Override
        public boolean m_8036_() {
            LunaticPriestEntity priest = (LunaticPriestEntity)this.getParentEntity();
            if (!priest.isActive()) {
                return false;
            }
            LivingEntity target = priest.m_5448_();
            return super.m_8036_() && priest.m_142582_((Entity)target) && target.m_6084_() && priest.m_6779_(target);
        }

        @Override
        public Projectile createProjectile(Level level, LivingEntity shooter, double accX, double accY, double accZ) {
            return new LunaticProjectileEntity(level, shooter, accX, accY, accZ, 0.7f + shooter.m_217043_().m_188501_(), ((LunaticPriestEntity)this.getParentEntity()).getShootVelocityInaccuracy());
        }

        @Override
        public int getShootTimeInterval() {
            LunaticPriestEntity priest = (LunaticPriestEntity)this.getParentEntity();
            int difficulty = priest.getDifficulty();
            if (difficulty == 0) {
                difficulty = 1;
            }
            return priest.isInPhase1() ? 19 / difficulty + (int)(priest.f_19796_.m_188501_() * 15.0f) : 14 / difficulty + (int)(priest.f_19796_.m_188501_() * 7.0f);
        }

        @Override
        public int getShootDelay() {
            return 0;
        }

        @Override
        public boolean doesShootTimeDecreaseWhenTargetOutOfSight() {
            return false;
        }

        @Override
        public double getYProjectileOffset() {
            return 0.5;
        }

        @Override
        protected void setAttacking(boolean bool) {
        }

        @Override
        public SoundEvent getShootSound() {
            return null;
        }
    }
}

