/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Bosses;

import fr.factionbedrock.aerialhell.Entity.AI.ActiveLookAtPlayerGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveMeleeAttackGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveNearestAttackableTargetGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveRandomLookAroundGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveWaterAvoidingRandomWalkingGoal;
import fr.factionbedrock.aerialhell.Entity.AI.SummonThreeEntitiesGoal;
import fr.factionbedrock.aerialhell.Entity.AbstractBossEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.ChainedGodEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.MudSpectralCycleMageEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.MudSpectralGolemEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.MudSpectralSoldierEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.TornSpiritEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Entities.AerialHellEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MudCycleMageEntity
extends AbstractBossEntity {
    private float damageAmountSinceLastSummon = 0.0f;

    public MudCycleMageEntity(EntityType<? extends MudCycleMageEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new ActiveMeleeAttackGoal(this, 1.25, false));
        this.f_21345_.m_25352_(3, (Goal)new SummonSpectralEntitiesGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ActiveWaterAvoidingRandomWalkingGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new ActiveLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new ActiveRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ActiveNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, TornSpiritEntity.class, true));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, ChainedGodEntity.class, 6.0f, 1.0, 1.2));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (flag) {
            this.damageAmountSinceLastSummon += amount;
        }
        return flag;
    }

    public boolean isHealthLowEnoughToSummonGolems() {
        return this.m_21223_() * 2.0f < this.m_21233_();
    }

    public boolean isDamageAmountSinceLastSummonSufficentToTriggerSummon() {
        return this.damageAmountSinceLastSummon > (float)(85 - 4 * this.getDifficulty());
    }

    public void resetDamageAmountSinceLastSummon() {
        this.damageAmountSinceLastSummon = 0.0f;
    }

    @Override
    public Item getTrophy() {
        return (Item)AerialHellBlocksAndItems.MUD_CYCLE_MAGE_TROPHY_ITEM.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 5) {
            this.playSummonParticles();
        } else {
            super.m_7822_(id);
        }
    }

    private void playSummonParticles() {
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 30; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0) - d0 * 10.0, this.m_20187_() - d1 * 10.0, this.m_20262_(1.0) - d2 * 10.0, 0.25 * ((double)this.f_19796_.m_188501_() - 0.5), 0.3, 0.25 * ((double)this.f_19796_.m_188501_() - 0.5));
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    public static class SummonSpectralEntitiesGoal
    extends SummonThreeEntitiesGoal {
        private boolean shouldFinishSummoningClones;
        private boolean isNotSummoningClones;

        public SummonSpectralEntitiesGoal(MudCycleMageEntity entity) {
            super((Mob)entity, 0.0);
        }

        public MudCycleMageEntity getMageGoalOwner() {
            return (MudCycleMageEntity)this.getGoalOwner();
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.getMageGoalOwner().isActive();
        }

        @Override
        public Entity createEntitiy(Level level) {
            if (!this.isNotSummoningClones && this.getGoalOwner().m_217043_().m_188503_(this.getMageGoalOwner().getDifficulty() + 1) > 2 || this.shouldFinishSummoningClones) {
                this.shouldFinishSummoningClones = true;
                return this.createClone();
            }
            this.isNotSummoningClones = true;
            if (!this.getMageGoalOwner().isHealthLowEnoughToSummonGolems()) {
                return this.createMudSpectralSoldier();
            }
            return this.getGoalOwner().m_217043_().m_188503_(2) == 0 ? this.createMudSpectralSoldier() : this.createMudSpectralGolem();
        }

        protected MudSpectralSoldierEntity createMudSpectralSoldier() {
            MudSpectralSoldierEntity entity = (MudSpectralSoldierEntity)((EntityType)AerialHellEntities.MUD_SPECTRAL_SOLDIER.get()).m_20615_(this.getGoalOwner().m_9236_());
            entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
            entity.m_32164_();
            return entity;
        }

        protected MudSpectralGolemEntity createMudSpectralGolem() {
            return (MudSpectralGolemEntity)((EntityType)AerialHellEntities.MUD_SPECTRAL_GOLEM.get()).m_20615_(this.getGoalOwner().m_9236_());
        }

        protected MudSpectralCycleMageEntity createClone() {
            MudSpectralCycleMageEntity entity = (MudSpectralCycleMageEntity)((EntityType)AerialHellEntities.MUD_SPECTRAL_CYCLE_MAGE.get()).m_20615_(this.getGoalOwner().m_9236_());
            entity.setMaster(this.getMageGoalOwner());
            return entity;
        }

        @Override
        protected void playEffect() {
            this.getGoalOwner().m_9236_().m_7605_((Entity)this.getGoalOwner(), (byte)5);
            super.playEffect();
        }

        @Override
        protected int getSummonTimerTargetValue() {
            return 200;
        }

        @Override
        protected void resetTask() {
            super.resetTask();
            this.getMageGoalOwner().resetDamageAmountSinceLastSummon();
            this.resetCloningStatus();
        }

        @Override
        protected boolean customSummonConditionMet() {
            return this.getMageGoalOwner().isDamageAmountSinceLastSummonSufficentToTriggerSummon();
        }

        private void resetCloningStatus() {
            this.shouldFinishSummoningClones = false;
            this.isNotSummoningClones = false;
        }
    }
}

