/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Monster;

import com.google.common.collect.ImmutableList;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveAvoidEntityGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveMisleadableNearestAttackableTargetGoal;
import fr.factionbedrock.aerialhell.Entity.AI.FleeBlockGoal;
import fr.factionbedrock.aerialhell.Entity.AbstractActivableEntity;
import fr.factionbedrock.aerialhell.Entity.AerialHellGolemEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CrystalGolemEntity
extends AerialHellGolemEntity {
    private int timeUntilActivation = 0;
    public static final EntityDataAccessor<Boolean> DISAPPEARING = SynchedEntityData.m_135353_(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeDisappearing;

    public CrystalGolemEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 6;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DISAPPEARING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Disappearing", this.isDisappearing());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDisappearing(compound.m_128471_("Disappearing"));
    }

    public boolean isDisappearing() {
        return (Boolean)this.f_19804_.m_135370_(DISAPPEARING);
    }

    public void setDisappearing(boolean flag) {
        this.f_19804_.m_135381_(DISAPPEARING, (Object)flag);
    }

    public int getTimeDisappearing() {
        return this.timeDisappearing;
    }

    public int getMaxLifeTime() {
        return 1200;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6785_(64.0) && this.f_19797_ > this.getMaxLifeTime() && !this.isDisappearing()) {
            this.setDisappearing(true);
        }
        if (this.isDisappearing()) {
            if (this.timeDisappearing < 95) {
                this.addDisappearingParticle(1);
            } else if (this.timeDisappearing < 100) {
                this.addDisappearingParticle(10);
            } else {
                this.m_146870_();
            }
            ++this.timeDisappearing;
        }
    }

    private void addDisappearingParticle(int number) {
        for (int i = 0; i < number; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)(2.0f * this.f_19796_.m_188501_()), this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, 0.5 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5 * ((double)this.f_19796_.m_188501_() - 0.5));
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22279_, 0.24);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        ImmutableList blocksToAvoid = ImmutableList.of((Object)((Block)AerialHellBlocksAndItems.SHADOW_TORCH.get()), (Object)((Block)AerialHellBlocksAndItems.SHADOW_WALL_TORCH.get()));
        this.f_21345_.m_25352_(1, new FleeBlockGoal((PathfinderMob)this, blocksToAvoid, 1.0, 1.2));
        this.f_21346_.m_25352_(2, new CrystalGolemNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21345_.m_25352_(1, new CrystalGolemAvoidEntityGoal<Player>(this, Player.class, 16.0f, 1.2, 1.5));
    }

    @Override
    public int getMinTimeToActivate() {
        return 10;
    }

    @Override
    public double getMinDistanceToActivate() {
        return 24.0;
    }

    @Override
    public float getYMotionOnAttack() {
        return 0.25f;
    }

    protected static class CrystalGolemNearestAttackableTargetGoal<T extends LivingEntity>
    extends ActiveMisleadableNearestAttackableTargetGoal<T> {
        public CrystalGolemNearestAttackableTargetGoal(AbstractActivableEntity entityIn, Class<T> targetClassIn, boolean checkSight) {
            super(entityIn, targetClassIn, checkSight);
        }

        @Override
        public boolean isPlayerMisleadingGoalOwner(Player player) {
            return EntityHelper.isLivingEntityMisleadingLunar((LivingEntity)player);
        }
    }

    protected static class CrystalGolemAvoidEntityGoal<T extends LivingEntity>
    extends ActiveAvoidEntityGoal<T> {
        public CrystalGolemAvoidEntityGoal(CrystalGolemEntity golemIn, Class<T> avoidClassIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super(golemIn, avoidClassIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
        }

        @Override
        public boolean m_8036_() {
            return ((CrystalGolemEntity)this.activableEntity).isDisappearing() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return ((CrystalGolemEntity)this.activableEntity).isDisappearing() && super.m_8045_();
        }
    }
}

