/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Monster;

import com.google.common.collect.ImmutableList;
import fr.factionbedrock.aerialhell.Entity.AI.FleeBlockGoal;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellMobEffects;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ShadowTrollEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DISAPPEARING = SynchedEntityData.m_135353_(ShadowTrollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeDisappearing;

    public ShadowTrollEntity(EntityType<? extends ShadowTrollEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        ImmutableList blocksToAvoid = ImmutableList.of((Object)((Block)AerialHellBlocksAndItems.VOLUCITE_TORCH.get()), (Object)((Block)AerialHellBlocksAndItems.VOLUCITE_WALL_TORCH.get()));
        this.f_21345_.m_25352_(1, new FleeBlockGoal((PathfinderMob)this, blocksToAvoid, 1.0, 1.2));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, (double)0.3f);
    }

    public boolean m_7327_(Entity attackedEntity) {
        if (super.m_7327_(attackedEntity)) {
            if (attackedEntity instanceof LivingEntity) {
                if (!EntityHelper.isLivingEntityShadowImmune((LivingEntity)attackedEntity)) {
                    if (!((LivingEntity)attackedEntity).m_21023_(MobEffects.f_19610_)) {
                        ((LivingEntity)attackedEntity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 35, 0));
                    } else if (!((LivingEntity)attackedEntity).m_21023_((MobEffect)AerialHellMobEffects.VULNERABILITY.get())) {
                        ((LivingEntity)attackedEntity).m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 60, 0));
                    } else {
                        ((LivingEntity)attackedEntity).m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 120, 0));
                    }
                } else {
                    ((LivingEntity)attackedEntity).m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 50, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if ((double)this.f_19796_.m_188501_() > 0.95) {
            EntityHelper.addBatParticle((LivingEntity)this, this.f_19796_, 1);
        }
        if (this.isDisappearing()) {
            if (this.timeDisappearing < 95) {
                EntityHelper.addBatParticle((LivingEntity)this, this.f_19796_, 1);
            } else if (this.timeDisappearing < 100) {
                EntityHelper.addBatParticle((LivingEntity)this, this.f_19796_, 10);
            } else {
                this.m_146870_();
            }
            ++this.timeDisappearing;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_21527_() && !this.isDisappearing()) {
            this.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_SHADOW_TROLL_DEATH.get(), 1.0f, 0.9f);
            this.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 100, 10, true, false)));
            this.setDisappearing(true);
        }
    }

    protected void m_7324_(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !EntityHelper.isLivingEntityShadowImmune((LivingEntity)entityIn)) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
        }
        super.m_7324_(entityIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DISAPPEARING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Disappearing", this.isDisappearing());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDisappearing(compound.m_128471_("Disappearing"));
    }

    public boolean isDisappearing() {
        return (Boolean)this.f_19804_.m_135370_(DISAPPEARING);
    }

    public void setDisappearing(boolean flag) {
        this.f_19804_.m_135381_(DISAPPEARING, (Object)flag);
    }

    public int getTimeDisappearing() {
        return this.timeDisappearing;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_SHADOW_TROLL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_SHADOW_TROLL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_SHADOW_TROLL_DEATH.get();
    }
}

