/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Passive;

import fr.factionbedrock.aerialhell.Entity.AI.KodamaRattleGoal;
import fr.factionbedrock.aerialhell.Entity.AerialHellAnimalEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Registry.Entities.AerialHellEntities;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class KodamaEntity
extends AerialHellAnimalEntity {
    private static final EntityDataAccessor<Integer> FACE_ID = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIZE_ID = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_RATTLING = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RATTLING_TILT_ANGLE = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int timeForceInvisible;
    public int rattleTimerMalus;
    public float rattleHeadRotZAmplitude;

    public KodamaEntity(EntityType<? extends KodamaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setRandomRattleTimerMalusAndHeadRotAmplitude();
    }

    public static boolean canSpawn(EntityType<? extends AerialHellAnimalEntity> entityType, LevelAccessor worldIn, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(AerialHellTags.Blocks.STELLAR_DIRT);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setRandomFaceAndSize();
        this.setRattling(false);
        return super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new KodamaRattleGoal(this));
        super.m_8099_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FACE_ID, (Object)1);
        this.f_19804_.m_135372_(SIZE_ID, (Object)1);
        this.f_19804_.m_135372_(IS_RATTLING, (Object)false);
        this.f_19804_.m_135372_(RATTLING_TILT_ANGLE, (Object)0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AerialHellAnimalEntity.m_21183_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.26);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.timeForceInvisible = this.getMaxTimeForceInvisible();
        return super.m_6469_(damageSource, amount);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mob) {
        return (AgeableMob)((EntityType)AerialHellEntities.KODAMA.get()).m_20615_(this.m_9236_());
    }

    public int getFaceId() {
        return (Integer)this.f_19804_.m_135370_(FACE_ID);
    }

    public void setFaceId(int id) {
        this.f_19804_.m_135381_(FACE_ID, (Object)id);
    }

    public int getSizeId() {
        return (Integer)this.f_19804_.m_135370_(SIZE_ID);
    }

    public void setSizeId(int id) {
        this.f_19804_.m_135381_(SIZE_ID, (Object)id);
    }

    public boolean isRattling() {
        return (Boolean)this.f_19804_.m_135370_(IS_RATTLING);
    }

    public void setRattling(boolean b) {
        this.f_19804_.m_135381_(IS_RATTLING, (Object)b);
    }

    public int getRattlingTiltAngle() {
        return (Integer)this.f_19804_.m_135370_(RATTLING_TILT_ANGLE);
    }

    public void setRattlingTiltAngle(int value) {
        this.f_19804_.m_135381_(RATTLING_TILT_ANGLE, (Object)value);
    }

    public int getMaxRattlingTiltAngle() {
        return 20;
    }

    public int getMaxTimeForceInvisible() {
        return 200;
    }

    private void setRandomFaceAndSize() {
        this.setFaceId(this.f_19796_.m_188503_(7) + 1);
        this.setSizeId(this.f_19796_.m_188503_(5) + 1);
    }

    private void setRandomRattleTimerMalusAndHeadRotAmplitude() {
        this.rattleTimerMalus = this.f_19796_.m_216339_(300, 600);
        int negative_or_positive = this.f_19796_.m_188503_(2) == 0 ? -1 : 1;
        this.rattleHeadRotZAmplitude = (float)(negative_or_positive * (5 + this.f_19796_.m_188503_(5))) / 10.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ % 6000 == 0 && !this.isRattling()) {
            this.setRandomRattleTimerMalusAndHeadRotAmplitude();
        }
        if (this.timeForceInvisible > 0) {
            --this.timeForceInvisible;
        } else if (this.detectNearbyDanger()) {
            this.timeForceInvisible = this.getMaxTimeForceInvisible();
        }
        super.m_8119_();
    }

    protected boolean detectNearbyDanger() {
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(10.0), EntitySelector.m_20410_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)5.0));
        for (Entity entity : nearbyEntities) {
            Player player;
            if (!(entity instanceof Player) || EntityHelper.isCreaOrSpecPlayer((Entity)(player = (Player)entity))) continue;
            return true;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_KODAMA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_KODAMA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_KODAMA_DEATH.get();
    }

    protected SoundEvent getRattleSound() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_KODAMA_RATTLE.get();
    }

    @Override
    public int m_8100_() {
        return 420;
    }

    public void playRattleSound() {
        SoundEvent soundevent = this.getRattleSound();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FaceId", this.getFaceId());
        compound.m_128405_("SizeId", this.getSizeId());
        compound.m_128379_("IsRattling", this.isRattling());
        compound.m_128405_("TiltAngle", this.getRattlingTiltAngle());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFaceId(compound.m_128451_("FaceId"));
        this.setSizeId(compound.m_128451_("SizeId"));
        this.setRattling(compound.m_128471_("IsRattling"));
        this.setRattlingTiltAngle(compound.m_128451_("TiltAngle"));
    }
}

