/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Projectile;

import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractLightProjectileEntity
extends ThrowableProjectile {
    private int ticksInAir = 0;

    public AbstractLightProjectileEntity(EntityType<? extends AbstractLightProjectileEntity> type, Level world) {
        super(type, world);
    }

    public AbstractLightProjectileEntity(EntityType<? extends AbstractLightProjectileEntity> type, LivingEntity shooter, Level world) {
        super(type, shooter, world);
        this.m_5602_((Entity)shooter);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.m_5496_(this.getShootSound(), 3.0f, 0.875f + 0.25f * this.f_19796_.m_188501_());
    }

    protected void m_8097_() {
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        double d1 = 0.5 - (double)this.f_19796_.m_188501_();
        double d2 = 0.5 - (double)this.f_19796_.m_188501_();
        double d3 = 0.5 - (double)this.f_19796_.m_188501_();
        this.m_9236_().m_7106_((ParticleOptions)this.getFlyParticle(), this.m_20185_() + d1, this.m_20186_() + 0.3 + d2, this.m_20189_() + d3, d1, d2, d3);
        super.m_8119_();
        if (!this.m_20096_()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir > 300) {
            this.m_146870_();
        }
        if (this.m_9236_().m_8055_(this.m_20183_()).m_204336_(AerialHellTags.Blocks.SOLID_ETHER)) {
            this.playHitEffect();
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        this.playHitEffect();
        super.m_6532_(result);
        if (result.m_6662_() != HitResult.Type.ENTITY && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public void playHitEffect() {
        double d1 = 0.5 - (double)this.f_19796_.m_188501_();
        double d2 = 0.5 - (double)this.f_19796_.m_188501_();
        double d3 = 0.5 - (double)this.f_19796_.m_188501_();
        double d4 = 0.5 - (double)this.f_19796_.m_188501_();
        double d5 = 0.5 - (double)this.f_19796_.m_188501_();
        double d6 = 0.5 - (double)this.f_19796_.m_188501_();
        this.m_9236_().m_7106_((ParticleOptions)this.getImpactParticle(), this.m_20185_() - d1, this.m_20186_() - d2, this.m_20189_() - d3, -d1, -d2, -d3);
        this.m_9236_().m_7106_((ParticleOptions)this.getImpactParticle(), this.m_20185_() - d4, this.m_20186_() - d5, this.m_20189_() - d6, -d4, -d5, -d6);
        this.m_9236_().m_7106_((ParticleOptions)this.getFlyParticle(), this.m_20185_() + d1, this.m_20186_() + d2, this.m_20189_() + d3, d1, d2, d3);
        this.m_9236_().m_7106_((ParticleOptions)this.getFlyParticle(), this.m_20185_() + d4, this.m_20186_() + d5, this.m_20189_() + d6, d4, d5, d6);
        this.playDisappearSound(1.0f, 0.75f + 0.5f * this.f_19796_.m_188501_());
    }

    protected void m_5790_(EntityHitResult result) {
        this.playDisappearSound(1.0f, 0.25f + 0.25f * this.f_19796_.m_188501_());
    }

    protected abstract SimpleParticleType getImpactParticle();

    protected abstract SimpleParticleType getFlyParticle();

    protected abstract SoundEvent getShootSound();

    protected abstract void playDisappearSound(float var1, float var2);
}

