/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Projectile;

import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Entity.Bosses.ChainedGodEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.LunaticPriestEntity;
import fr.factionbedrock.aerialhell.Entity.Projectile.AbstractLightProjectileEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellDamageTypes;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Registry.Entities.AerialHellEntities;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class LunaticProjectileEntity
extends AbstractLightProjectileEntity {
    public LunaticProjectileEntity(EntityType<? extends LunaticProjectileEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public LunaticProjectileEntity(Level world, LivingEntity shooter, double accelX, double accelY, double accelZ, float velocity, float inaccuracy) {
        super((EntityType<? extends AbstractLightProjectileEntity>)((EntityType)AerialHellEntities.LUNATIC_PROJECTILE.get()), shooter, world);
        this.m_6686_(accelX, accelY, accelZ, velocity, inaccuracy);
    }

    @Override
    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    private boolean targetIsImmuneToLunaticProjectileKb(Entity target) {
        return target instanceof ChainedGodEntity || target instanceof LunaticPriestEntity || target instanceof Player && ((Player)target).m_7500_();
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity target = result.m_82443_();
        if (target != this.m_19749_()) {
            target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 5.0f);
            float amount = 4.0f;
            if (EntityHelper.isShadowEntity(target) || target instanceof LivingEntity && EntityHelper.isLivingEntityVulnerable((LivingEntity)target)) {
                amount *= 2.0f;
            }
            target.m_6469_(AerialHellDamageTypes.getDamageSource(this.m_9236_(), AerialHellDamageTypes.LUNATIC_PROJECTION), amount);
            if (!this.targetIsImmuneToLunaticProjectileKb(target)) {
                target.m_5997_(this.m_20184_().f_82479_, 0.3, this.m_20184_().f_82481_);
            }
        }
    }

    @Override
    protected SimpleParticleType getImpactParticle() {
        return (SimpleParticleType)AerialHellParticleTypes.COPPER_PINE_LEAVES.get();
    }

    @Override
    protected SimpleParticleType getFlyParticle() {
        return (SimpleParticleType)AerialHellParticleTypes.LUNATIC_PARTICLE.get();
    }

    @Override
    protected SoundEvent getShootSound() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_LUNATIC_PROJECTILE_SHOOT.get();
    }

    @Override
    protected void playDisappearSound(float volume, float pitch) {
        this.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_LUNATIC_PROJECTILE_DISAPPEAR.get(), volume, pitch);
    }
}

