/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Event.Listeners;

import fr.factionbedrock.aerialhell.Entity.Bosses.LilithEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.LunaticPriestEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.CrystalGolemEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShadowAutomatonEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShadowTrollEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellDamageTypes;
import fr.factionbedrock.aerialhell.Registry.AerialHellMobEffects;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import fr.factionbedrock.aerialhell.Util.ItemHelper;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ToolsAndArmorEventListener {
    @SubscribeEvent
    public static void onProjectileCollideWithEntity(ProjectileImpactEvent event) {
        Entity hitEntity;
        Entity projectile = event.getEntity();
        if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && ((hitEntity = ((EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof ShadowTrollEntity || hitEntity instanceof ShadowAutomatonEntity) && !EntityHelper.isLightProjectile(projectile)) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        Entity sourceEntity = damageSource.m_7639_();
        LivingEntity target = event.getEntity();
        ToolsAndArmorEventListener.applyEffectsDueToPotionEffects(event, damageSource, target);
        if (target instanceof Player) {
            Item targetMainHandItem = ((Player)target).m_21205_().m_41720_();
            ToolsAndArmorEventListener.applyEffectsBasedOnTargetHandEquippedItem(event, targetMainHandItem, target);
        } else {
            Iterable handStuff = target.m_6167_();
            for (ItemStack handItemStack : handStuff) {
                ToolsAndArmorEventListener.applyEffectsBasedOnTargetHandEquippedItem(event, handItemStack.m_41720_(), target);
            }
        }
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)sourceEntity;
            Iterable stuff = target.m_6168_();
            ToolsAndArmorEventListener.applyEffectsBasedOnTargetEquippedArmor(event, stuff, source, target);
            if (source instanceof Player) {
                ItemStack mainHandItemStack = ((Player)source).m_21205_();
                ToolsAndArmorEventListener.applyEffectsBasedOnSourceHandEquippedItem(event, mainHandItemStack, source, target);
                ToolsAndArmorEventListener.applyTraitorEffectIfNecessary((Player)source, target);
            } else {
                Iterable handStuff = source.m_6167_();
                for (ItemStack handItemStack : handStuff) {
                    ToolsAndArmorEventListener.applyEffectsBasedOnSourceHandEquippedItem(event, handItemStack, source, target);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHarvest(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack selectedItemStack = player.m_150109_().m_36056_();
        BlockState state = event.getState();
        float speed = event.getOriginalSpeed();
        if (state != null && selectedItemStack.m_204117_(AerialHellTags.Items.ARSONIST) && player.m_20094_() > 0) {
            event.setNewSpeed(speed * 2.0f);
        } else if (selectedItemStack.m_41720_() == AerialHellBlocksAndItems.STELLAR_STONE_BREAKER.get() && state.m_60734_() == AerialHellBlocksAndItems.STELLAR_STONE.get()) {
            event.setNewSpeed(speed * 2.0f);
        }
        if (state != null && state.m_204336_(AerialHellTags.Blocks.NEEDS_LUNAR_TOOL) && ItemHelper.getItemMiningLevel(selectedItemStack.m_41720_()) < 4) {
            event.setNewSpeed(Math.min(speed, 4.0f));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 0));
        }
        if (state != null && state.m_60713_((Block)AerialHellBlocksAndItems.EYE_SHADOW_PINE_LOG.get()) && !EntityHelper.isLivingEntityShadowImmune((LivingEntity)player) && !player.m_7500_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 30, 0));
        }
    }

    @SubscribeEvent
    public static void addReach(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().m_41720_();
        if ((item == AerialHellBlocksAndItems.REAPER_SCYTHE.get() || item == AerialHellBlocksAndItems.FORGOTTEN_BATTLE_TRIDENT.get()) && event.getSlotType() == EquipmentSlot.MAINHAND) {
            event.addModifier((Attribute)ForgeMod.ENTITY_REACH.get(), new AttributeModifier(UUID.fromString("6127DB5B-1AE8-4030-940E-512C1F160890"), "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
        }
    }

    public static void applyEffectsDueToPotionEffects(LivingHurtEvent event, DamageSource damageSource, LivingEntity target) {
        float amount = event.getAmount();
        if ((damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268546_)) && target.m_21023_((MobEffect)AerialHellMobEffects.GOD.get())) {
            event.setCanceled(true);
        }
        if (EntityHelper.isLivingEntityVulnerable(target)) {
            int multiplier = target.m_21124_((MobEffect)AerialHellMobEffects.VULNERABILITY.get()).m_19564_() + 1;
            event.setAmount(amount * 2.0f * (float)multiplier);
            if (event.getSource().m_7639_() instanceof LilithEntity) {
                event.setAmount(amount * 1.5f * (float)multiplier);
            }
        }
    }

    public static void applyEffectsBasedOnTargetHandEquippedItem(LivingHurtEvent event, Item targetEquippedItem, LivingEntity target) {
        float amount = event.getAmount();
        if (targetEquippedItem == AerialHellBlocksAndItems.GLASS_CANON_SWORD.get()) {
            event.setAmount(amount * 2.0f);
        }
    }

    public static void applyEffectsBasedOnTargetEquippedArmor(LivingHurtEvent event, Iterable<ItemStack> armorStuff, LivingEntity source, LivingEntity target) {
        float amount = event.getAmount();
        for (ItemStack armorStack : armorStuff) {
            if (armorStack.m_204117_(AerialHellTags.Items.MAGMATIC_GEL)) {
                if (source instanceof Player) {
                    if (!((Player)source).m_7500_()) {
                        source.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 120, 1, true, false)));
                    }
                } else {
                    source.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 120, 1, true, false)));
                }
            }
            if (!armorStack.m_204117_(AerialHellTags.Items.ARSONIST)) continue;
            source.m_20254_(5);
            if (target.m_20094_() <= 0) continue;
            event.setAmount(amount * 0.93f);
        }
    }

    public static void applyEffectsBasedOnSourceHandEquippedItem(LivingHurtEvent event, ItemStack sourceEquippedItemStack, LivingEntity source, LivingEntity target) {
        Item sourceEquippedItem = sourceEquippedItemStack.m_41720_();
        float amount = event.getAmount();
        if (sourceEquippedItemStack.m_204117_(AerialHellTags.Items.MAGMATIC_GEL)) {
            int count = 0;
            for (ItemStack armorStack : source.m_6168_()) {
                if (!armorStack.m_204117_(AerialHellTags.Items.MAGMATIC_GEL)) continue;
                ++count;
            }
            int amplifier = count == 4 ? 1 : 0;
            target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 120, amplifier, true, false)));
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.ABSOLUTE_ZERO_SWORD.get()) {
            target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 100, 2, true, false)));
        } else if (sourceEquippedItemStack.m_204117_(AerialHellTags.Items.ARSONIST)) {
            target.m_20254_(5);
            if (source.m_20094_() > 0) {
                event.setAmount(amount * 1.5f);
            }
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.DISLOYAL_SWORD.get()) {
            target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 100, 0, true, false)));
            target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19613_, 100, 0, true, false)));
            target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19599_, 100, 0, true, false)));
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.GOD_SWORD.get()) {
            target.m_20254_(5);
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.REAPER_SCYTHE.get()) {
            if (!EntityHelper.isLivingEntityShadowImmune(target)) {
                target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19610_, 100, 0, true, false)));
                target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19613_, 100, 1, true, false)));
                target.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 100, 1, true, false)));
                target.m_7292_(new MobEffectInstance(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 70, 0, true, false)));
            } else {
                source.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19615_, 80, 2, true, false)));
            }
            source.m_7292_(new MobEffectInstance(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 60, 0, true, false)));
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.CURSED_SWORD.get() || sourceEquippedItem == AerialHellBlocksAndItems.CURSED_AXE.get()) {
            float damage_return_amount = EntityHelper.isLivingEntityShadowImmune(source) || EntityHelper.isLivingEntityVulnerable(target) ? amount / 2.0f : amount;
            source.m_6469_(AerialHellDamageTypes.getDamageSource(event.getEntity().m_9236_(), AerialHellDamageTypes.CURSED_TOOL), damage_return_amount);
            if (!EntityHelper.isLivingEntityShadowImmune(target)) {
                if (EntityHelper.isLightEntity((Entity)target) && !(target instanceof LunaticPriestEntity)) {
                    target.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 40, 1));
                } else {
                    target.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.VULNERABILITY.get(), 40, 0));
                }
            }
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.SWORD_OF_LIGHT.get() || sourceEquippedItem == AerialHellBlocksAndItems.AXE_OF_LIGHT.get() || sourceEquippedItem == AerialHellBlocksAndItems.LUNATIC_SWORD.get() || sourceEquippedItem == AerialHellBlocksAndItems.LUNATIC_AXE.get() || sourceEquippedItem == AerialHellBlocksAndItems.LUNATIC_HOE.get() || sourceEquippedItem == AerialHellBlocksAndItems.LUNATIC_SHOVEL.get() || sourceEquippedItem == AerialHellBlocksAndItems.LUNATIC_PICKAXE.get() || sourceEquippedItem == AerialHellBlocksAndItems.STELLAR_STONE_BREAKER.get()) {
            if (EntityHelper.isShadowEntity((Entity)target)) {
                if (sourceEquippedItem == AerialHellBlocksAndItems.SWORD_OF_LIGHT.get() || sourceEquippedItem == AerialHellBlocksAndItems.AXE_OF_LIGHT.get()) {
                    event.setAmount(amount * 1.8f);
                } else {
                    event.setAmount(amount * 1.4f);
                }
            }
        } else if (sourceEquippedItem == AerialHellBlocksAndItems.NETHERIAN_KING_SWORD.get() && source.m_9236_().m_46472_() == Level.f_46429_) {
            event.setAmount(amount * 2.0f);
        }
    }

    public static void applyTraitorEffectIfNecessary(Player source, LivingEntity target) {
        if (source.m_7500_()) {
            return;
        }
        if ((target instanceof CrystalGolemEntity || target instanceof LunaticPriestEntity) && EntityHelper.isLivingEntityMisleadingLunar((LivingEntity)source)) {
            source.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.TRAITOR.get(), 12000, 0));
        } else if ((target instanceof ShadowAutomatonEntity || target instanceof LilithEntity) && EntityHelper.isLivingEntityMisleadingShadow((LivingEntity)source)) {
            source.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.TRAITOR.get(), 12000, 0));
        }
    }
}

