/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Item.Material;

import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AerialHellArmorMaterials {
    public static final ArmorMaterial ruby = new AerialHellArmorMaterial("aerialhell:ruby", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.f_11677_, 0.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.RUBY.get()}));
    public static final ArmorMaterial azurite = new AerialHellArmorMaterial("aerialhell:azurite", 10, new int[]{1, 3, 5, 2}, 25, SoundEvents.f_11676_, 0.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.AZURITE_CRYSTAL.get()}));
    public static final ArmorMaterial magmatic_gel = new AerialHellArmorMaterial("aerialhell:magmatic_gel", 7, new int[]{1, 3, 5, 2}, 25, SoundEvents.f_11676_, 0.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.MAGMATIC_GEL.get()}));
    public static final ArmorMaterial obsidian = new AerialHellArmorMaterial("aerialhell:obsidian", 37, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11673_, 2.0, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.OBSIDIAN_SHARD.get()}));
    public static final ArmorMaterial volucite = new AerialHellArmorMaterial("aerialhell:volucite", 35, new int[]{4, 7, 9, 4}, 10, SoundEvents.f_11673_, 2.5, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.AZURITE_CRYSTAL.get()}));
    public static final ArmorMaterial lunatic = new AerialHellArmorMaterial("aerialhell:lunatic", 33, new int[]{4, 7, 8, 3}, 15, SoundEvents.f_11676_, 1.5, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.LUNATIC_CRYSTAL.get()}));
    public static final ArmorMaterial shadow = new AerialHellArmorMaterial("aerialhell:shadow", 25, new int[]{4, 7, 7, 3}, 15, SoundEvents.f_11678_, 1.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.CURSED_CRYSAL.get()}));
    public static final ArmorMaterial arsonist = new AerialHellArmorMaterial("aerialhell:arsonist", 37, new int[]{5, 8, 9, 4}, 15, SoundEvents.f_11679_, 3.0, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AerialHellBlocksAndItems.ARSONIST_INGOT.get()}));

    private static class AerialHellArmorMaterial
    implements ArmorMaterial {
        private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE = AerialHellArmorMaterial.makeDamageReductionForArmorTypeEnumMap(new int[]{13, 15, 16, 11});
        private final String name;
        private final int maxDamageFactor;
        private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final float knockbackResistance;
        private final LazyLoadedValue<Ingredient> repairMaterial;

        public AerialHellArmorMaterial(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, double toughness, float knockbackResistance, Supplier<Ingredient> supplier) {
            this.name = name;
            this.maxDamageFactor = maxDamageFactor;
            this.protectionFunctionForType = AerialHellArmorMaterial.makeDamageReductionForArmorTypeEnumMap(damageReductionAmountArray);
            this.enchantability = enchantability;
            this.soundEvent = soundEvent;
            this.toughness = (float)toughness;
            this.knockbackResistance = knockbackResistance;
            this.repairMaterial = new LazyLoadedValue(supplier);
        }

        public int m_266425_(ArmorItem.Type type) {
            return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.maxDamageFactor;
        }

        public int m_7366_(ArmorItem.Type type) {
            return this.protectionFunctionForType.get(type);
        }

        public int m_6646_() {
            return this.enchantability;
        }

        public SoundEvent m_7344_() {
            return this.soundEvent;
        }

        public Ingredient m_6230_() {
            return (Ingredient)this.repairMaterial.m_13971_();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }

        private static EnumMap<ArmorItem.Type, Integer> makeDamageReductionForArmorTypeEnumMap(int[] damageReductionArray) {
            return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, damageReductionArray[0]);
                map.put(ArmorItem.Type.LEGGINGS, damageReductionArray[1]);
                map.put(ArmorItem.Type.CHESTPLATE, damageReductionArray[2]);
                map.put(ArmorItem.Type.HELMET, damageReductionArray[3]);
            });
        }
    }
}

