/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Util;

import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellStructures;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class StructureHelper {
    public static boolean hasDungeonNearby(ChunkGenerator chunkGenerator, long seed, int chunkX, int chunkZ, int checkRadius) {
        return StructureHelper.hasDungeonNearby(chunkGenerator, seed, chunkX, chunkZ, checkRadius, true);
    }

    public static boolean hasDungeonNearby(ChunkGenerator chunkGenerator, long seed, int chunkX, int chunkZ, int checkRadius, boolean checkBaseChunk) {
        boolean mudDungeonNearby = StructureHelper.hasMudDungeonNearby(chunkGenerator, seed, chunkX, chunkZ, checkRadius, checkBaseChunk);
        boolean lunaticTempleNearby = StructureHelper.hasLunaticTempleNearby(chunkGenerator, seed, chunkX, chunkZ, checkRadius, checkBaseChunk);
        boolean goldenNetherPrisonNearby = StructureHelper.hasGoldenNetherPrisonNearby(chunkGenerator, seed, chunkX, chunkZ, checkRadius, checkBaseChunk);
        boolean shadowCatacombsNearby = StructureHelper.hasShadowCatacombsNearby(chunkGenerator, seed, chunkX, chunkZ, checkRadius, checkBaseChunk);
        return mudDungeonNearby || lunaticTempleNearby || goldenNetherPrisonNearby || shadowCatacombsNearby;
    }

    public static boolean hasDungeonNearby(Structure.GenerationContext context, int blockCheckDistance, boolean checkAltitude, int yCheck) {
        return false;
    }

    public static boolean temporaryCheck_isStructureGeneratingInAerialHell(Structure.GenerationContext context) {
        BlockPos genPos = context.f_226628_().m_151394_(100);
        int x = genPos.m_123341_();
        int z = genPos.m_123343_();
        int y = context.f_226622_().m_223235_(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_());
        BlockState surfaceBlock = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_()).m_183556_(y);
        boolean isSurfaceBlockAnAerialHellSurfaceBlock = surfaceBlock.m_60713_((Block)AerialHellBlocksAndItems.STELLAR_GRASS_BLOCK.get()) || surfaceBlock.m_60713_((Block)AerialHellBlocksAndItems.STELLAR_STONE.get()) || surfaceBlock.m_60713_((Block)AerialHellBlocksAndItems.SHADOW_GRASS_BLOCK.get()) || surfaceBlock.m_60713_((Block)AerialHellBlocksAndItems.SLIPPERY_SAND.get());
        return isSurfaceBlockAnAerialHellSurfaceBlock;
    }

    public static boolean hasMudDungeonNearby(ChunkGenerator chunkGenerator, long seed, int chunkX, int chunkZ, int checkRadius, boolean checkBaseChunk) {
        int temporaryCheckRadius = Math.min(3, checkRadius);
        return false;
    }

    public static boolean hasLunaticTempleNearby(ChunkGenerator chunkGenerator, long seed, int chunkX, int chunkZ, int checkRadius, boolean checkBaseChunk) {
        return false;
    }

    public static boolean hasGoldenNetherPrisonNearby(ChunkGenerator chunkGenerator, long seed, int chunkX, int chunkZ, int checkRadius, boolean checkBaseChunk) {
        return false;
    }

    public static boolean hasShadowCatacombsNearby(ChunkGenerator chunkGenerator, long seed, int chunkX, int chunkZ, int checkRadius, boolean checkBaseChunk) {
        return false;
    }

    public static HolderSet<StructureSet> getDungeonsSetHolderSet(RegistryAccess registryAccess) {
        HolderLookup.RegistryLookup holderGetter = registryAccess.m_255025_(Registries.f_256998_);
        HolderSet.Direct dungeonsHolderSet = HolderSet.m_205809_((Holder[])new Holder[]{holderGetter.m_255043_(AerialHellStructures.Sets.MUD_DUNGEON_STRUCTURE), holderGetter.m_255043_(AerialHellStructures.Sets.LUNATIC_TEMPLE_STRUCTURE), holderGetter.m_255043_(AerialHellStructures.Sets.GOLDEN_NETHER_PRISON_STRUCTURE), holderGetter.m_255043_(AerialHellStructures.Sets.SHADOW_CATACOMBS_STRUCTURE)});
        return dungeonsHolderSet;
    }

    public static HolderSet<Structure> getDungeonsHolderSet(RegistryAccess registryAccess) {
        Optional optional = registryAccess.m_175515_(Registries.f_256944_).m_203431_(AerialHellTags.Structures.DUNGEONS);
        return optional.orElse(null);
    }
}

