/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.BlockHelper;
import fr.factionbedrock.aerialhell.World.Features.Config.AerialHellTwistingVinesConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class AerialHellTwistingVinesFeature
extends Feature<AerialHellTwistingVinesConfig> {
    private Supplier<Block> headBlock;
    private Supplier<Block> bodyBlock;

    public AerialHellTwistingVinesFeature(Codec<AerialHellTwistingVinesConfig> codec, Supplier<Block> headBlock, Supplier<Block> bodyBlock) {
        super(codec);
        this.headBlock = headBlock;
        this.bodyBlock = bodyBlock;
    }

    public boolean m_142674_(FeaturePlaceContext<AerialHellTwistingVinesConfig> context) {
        BlockPos blockpos;
        boolean needsRoof = ((AerialHellTwistingVinesConfig)context.m_159778_()).needsRoof().equals("true");
        WorldGenLevel worldgenlevel = context.m_159774_();
        if (AerialHellTwistingVinesFeature.isInvalidPlacementLocation((LevelAccessor)worldgenlevel, blockpos = context.m_159777_(), needsRoof)) {
            return false;
        }
        RandomSource random = context.m_225041_();
        AerialHellTwistingVinesConfig twistingvinesconfig = (AerialHellTwistingVinesConfig)context.m_159778_();
        int i = twistingvinesconfig.spreadWidth();
        int j = twistingvinesconfig.spreadHeight();
        int k = twistingvinesconfig.maxHeight();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l < i * i; ++l) {
            blockpos$mutableblockpos.m_122190_((Vec3i)blockpos).m_122184_(Mth.m_216271_((RandomSource)random, (int)(-i), (int)i), Mth.m_216271_((RandomSource)random, (int)(-j), (int)j), Mth.m_216271_((RandomSource)random, (int)(-i), (int)i));
            if (!AerialHellTwistingVinesFeature.findFirstAirBlockAboveGround((LevelAccessor)worldgenlevel, blockpos$mutableblockpos) || AerialHellTwistingVinesFeature.isInvalidPlacementLocation((LevelAccessor)worldgenlevel, (BlockPos)blockpos$mutableblockpos, false)) continue;
            int i1 = Mth.m_216271_((RandomSource)random, (int)1, (int)k);
            if (random.m_188503_(6) == 0) {
                i1 *= 2;
            }
            if (random.m_188503_(5) == 0) {
                i1 = 1;
            }
            AerialHellTwistingVinesFeature.placeWeepingVinesColumn((LevelAccessor)worldgenlevel, random, blockpos$mutableblockpos, i1, 17, 25, this.headBlock.get(), this.bodyBlock.get());
        }
        return true;
    }

    private static boolean findFirstAirBlockAboveGround(LevelAccessor level, BlockPos.MutableBlockPos mutablePos) {
        do {
            mutablePos.m_122184_(0, -1, 0);
            if (!level.m_151570_((BlockPos)mutablePos)) continue;
            return false;
        } while (level.m_8055_((BlockPos)mutablePos).m_60795_());
        mutablePos.m_122184_(0, 1, 0);
        return true;
    }

    public static void placeWeepingVinesColumn(LevelAccessor level, RandomSource rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, Block headBlock, Block bodyBlock) {
        for (int i = 1; i <= height; ++i) {
            if (level.m_46859_((BlockPos)mutablePos)) {
                if (i == height || !level.m_46859_(mutablePos.m_7494_())) {
                    level.m_7731_((BlockPos)mutablePos, (BlockState)headBlock.m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)rand, (int)minAge, (int)maxAge))), 2);
                    break;
                }
                level.m_7731_((BlockPos)mutablePos, bodyBlock.m_49966_(), 2);
            }
            mutablePos.m_122173_(Direction.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(LevelAccessor level, BlockPos pos, boolean needsRoof) {
        if (!level.m_46859_(pos)) {
            return true;
        }
        if (needsRoof && !BlockHelper.hasAnySolidSurfaceAbove((LevelReader)level, pos, 3)) {
            return true;
        }
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        return !blockstate.m_204336_(AerialHellTags.Blocks.STELLAR_DIRT) && !blockstate.m_60713_((Block)AerialHellBlocksAndItems.SLIPPERY_SAND.get()) && !blockstate.m_60713_(Blocks.f_50134_) && !blockstate.m_60713_(Blocks.f_50690_) && !blockstate.m_60713_(Blocks.f_50692_);
    }
}

