/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.FeatureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DanglingChainFeature
extends Feature<NoneFeatureConfiguration> {
    public DanglingChainFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        ChunkGenerator generator = context.m_159775_();
        boolean canGenerate = reader.m_8055_(blockPos.m_7495_()).m_60734_().equals(Blocks.f_50016_) && reader.m_8055_(blockPos).m_204336_(AerialHellTags.Blocks.STELLAR_STONE) && this.hasAnyStoneBlockAbove(blockPos.m_122013_(4).m_122025_(4), reader, 10) && this.hasAnyStoneBlockAbove(blockPos.m_122013_(4).m_122030_(4), reader, 10) && this.hasAnyStoneBlockAbove(blockPos.m_122020_(4).m_122025_(4), reader, 10) && this.hasAnyStoneBlockAbove(blockPos.m_122020_(4).m_122030_(4), reader, 10);
        boolean generatesInDungeon = FeatureHelper.isFeatureGeneratingNextToDungeon(context);
        if (canGenerate && !generatesInDungeon) {
            int chance_malus = 0;
            BlockPos placementPos = blockPos.m_6630_(5);
            LinkDirection linkDirection = rand.m_188503_(2) == 0 ? LinkDirection.NORTH_SOUTH : LinkDirection.WEST_EAST;
            this.generateChainLink(reader, rand, placementPos, linkDirection);
            while (rand.m_188503_(10) > 0 + chance_malus && placementPos.m_123342_() > 20) {
                ++chance_malus;
                placementPos = placementPos.m_6625_(5);
                linkDirection = linkDirection == LinkDirection.NORTH_SOUTH ? LinkDirection.WEST_EAST : LinkDirection.NORTH_SOUTH;
                this.generateChainLink(reader, rand, placementPos, linkDirection);
            }
            placementPos = placementPos.m_6625_(5);
            linkDirection = linkDirection == LinkDirection.NORTH_SOUTH ? LinkDirection.WEST_EAST : LinkDirection.NORTH_SOUTH;
            this.generateLastLink(reader, rand, placementPos, linkDirection);
            return true;
        }
        return false;
    }

    protected void generateChainLink(WorldGenLevel reader, RandomSource rand, BlockPos blockPos, LinkDirection direction) {
        if (direction == LinkDirection.NORTH_SOUTH) {
            for (int i = -2; i < 3; ++i) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(i, 0, 0), this.getRandomBlockstateToPlace(rand));
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(i, -6, 0), this.getRandomBlockstateToPlace(rand));
            }
            for (int y = -1; y > -6; --y) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(-2, y, 0), this.getRandomBlockstateToPlace(rand));
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(2, y, 0), this.getRandomBlockstateToPlace(rand));
            }
        } else {
            for (int i = -2; i < 3; ++i) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, 0, i), this.getRandomBlockstateToPlace(rand));
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, -6, i), this.getRandomBlockstateToPlace(rand));
            }
            for (int y = -1; y > -6; --y) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, y, -2), this.getRandomBlockstateToPlace(rand));
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, y, 2), this.getRandomBlockstateToPlace(rand));
            }
        }
    }

    protected void generateLastLink(WorldGenLevel reader, RandomSource rand, BlockPos blockPos, LinkDirection direction) {
        if (direction == LinkDirection.NORTH_SOUTH) {
            int y;
            for (int i = -2; i < 3; ++i) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(i, 0, 0), this.getRandomBlockstateToPlace(rand));
            }
            this.setBlockStateIfPossible(reader, blockPos.m_7918_(2, -1, 0), this.getRandomBlockstateToPlace(rand));
            this.setBlockStateIfPossible(reader, blockPos.m_7918_(-2, -1, 0), this.getRandomBlockstateToPlace(rand));
            for (y = -2; y > -6; --y) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(-2, y, 0), this.getRandomBlockstateToPlace(rand));
                if (rand.m_188503_(3) == 0) break;
            }
            for (y = -1; y > -6; --y) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(2, y, 0), this.getRandomBlockstateToPlace(rand));
                if (rand.m_188503_(3) != 0) {
                    continue;
                }
                break;
            }
        } else {
            int y;
            for (int i = -2; i < 3; ++i) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, 0, i), this.getRandomBlockstateToPlace(rand));
            }
            this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, -1, 2), this.getRandomBlockstateToPlace(rand));
            this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, -1, -2), this.getRandomBlockstateToPlace(rand));
            for (y = -2; y > -6; --y) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, y, -2), this.getRandomBlockstateToPlace(rand));
                if (rand.m_188503_(3) == 0) break;
            }
            for (y = -1; y > -6; --y) {
                this.setBlockStateIfPossible(reader, blockPos.m_7918_(0, y, 2), this.getRandomBlockstateToPlace(rand));
                if (rand.m_188503_(3) != 0) {
                    continue;
                }
                break;
            }
        }
    }

    private BlockState getRandomBlockstateToPlace(RandomSource rand) {
        return rand.m_188503_(4) == 0 ? ((Block)AerialHellBlocksAndItems.MOSSY_STELLAR_COBBLESTONE.get()).m_49966_() : ((Block)AerialHellBlocksAndItems.STELLAR_STONE_BRICKS.get()).m_49966_();
    }

    private void setBlockStateIfPossible(WorldGenLevel reader, BlockPos blockPos, BlockState state) {
        if (this.isReplaceable(reader, blockPos)) {
            reader.m_7731_(blockPos, state, 0);
        }
    }

    private boolean isReplaceable(WorldGenLevel reader, BlockPos blockPos) {
        BlockState previousBlock = reader.m_8055_(blockPos);
        return previousBlock.m_60795_() || previousBlock.m_204336_(AerialHellTags.Blocks.STELLAR_STONE) || previousBlock.m_204336_(AerialHellTags.Blocks.FEATURE_CAN_REPLACE);
    }

    private boolean hasAnyStoneBlockAbove(BlockPos pos, WorldGenLevel reader, int yMaxDistance) {
        BlockPos blockpos = pos.m_7494_();
        while (blockpos.m_123342_() < pos.m_123342_() + yMaxDistance) {
            if (reader.m_8055_(blockpos).m_204336_(AerialHellTags.Blocks.STELLAR_STONE)) {
                return true;
            }
            blockpos = blockpos.m_7494_();
        }
        return false;
    }

    private static enum LinkDirection {
        NORTH_SOUTH,
        WEST_EAST;

    }
}

