/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.FeatureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GiantGanodermaApplanatumFeature
extends Feature<NoneFeatureConfiguration> {
    public GiantGanodermaApplanatumFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        boolean canGenerate = !(reader.m_8055_(pos.m_6630_(3)).m_60734_().equals(Blocks.f_50016_) || !(reader.m_8055_(pos.m_122013_(2)).m_60734_().equals(Blocks.f_50016_) ^ reader.m_8055_(pos.m_122020_(2)).m_60734_().equals(Blocks.f_50016_)) && !(reader.m_8055_(pos.m_122025_(2)).m_60734_().equals(Blocks.f_50016_) ^ reader.m_8055_(pos.m_122030_(2)).m_60734_().equals(Blocks.f_50016_)) || !reader.m_8055_(pos).m_204336_(AerialHellTags.Blocks.STELLAR_STONE) && reader.m_8055_(pos).m_60734_() != AerialHellBlocksAndItems.STELLAR_DIRT.get());
        boolean generatesInDungeon = FeatureHelper.isFeatureGeneratingNextToDungeon(context);
        if (canGenerate && !generatesInDungeon) {
            this.generateCap(reader, rand, pos);
            return true;
        }
        return false;
    }

    protected void generateCap(WorldGenLevel reader, RandomSource rand, BlockPos blockPos) {
        BlockPos.MutableBlockPos placementPos = new BlockPos.MutableBlockPos();
        boolean isHuge = rand.m_188503_(11) == 0;
        int a = this.getRandomRadius(rand, isHuge);
        int b = this.getRandomHeight(rand, isHuge);
        int c = this.getRandomRadius(rand, isHuge);
        int bonus = 1;
        for (int x = -a - bonus; x <= a + bonus; ++x) {
            for (int y = 0; y <= b + bonus; ++y) {
                for (int z = -c - bonus; z <= c + bonus; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.isPosInsideEllipsis(pos, a, b, c)) continue;
                    boolean downInEll = this.isPosInsideEllipsis(pos.m_7495_(), a, b, c);
                    boolean northInEll = this.isPosInsideEllipsis(pos.m_122012_(), a, b, c);
                    boolean southInEll = this.isPosInsideEllipsis(pos.m_122019_(), a, b, c);
                    boolean westInEll = this.isPosInsideEllipsis(pos.m_122024_(), a, b, c);
                    boolean eastInEll = this.isPosInsideEllipsis(pos.m_122029_(), a, b, c);
                    if (!downInEll && !northInEll && !southInEll && !westInEll && !eastInEll) continue;
                    boolean isUpCap = this.isCapBlockPos(pos.m_7494_(), a, b, c);
                    placementPos.m_122190_((Vec3i)blockPos.m_121955_((Vec3i)pos));
                    if (!FeatureHelper.isReplaceableByLogOrLeavesFeature((LevelAccessor)reader, (BlockPos)placementPos, true)) continue;
                    reader.m_7731_((BlockPos)placementPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)AerialHellBlocksAndItems.GIANT_GANODERMA_APPLANATUM_BLOCK.get()).m_49966_().m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(!northInEll))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(!southInEll))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(!westInEll))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(!eastInEll))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(!downInEll && y != 0))).m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(!isUpCap)), 0);
                }
            }
        }
    }

    private int getRandomRadius(RandomSource rand, boolean isHuge) {
        return isHuge ? (int)(5.0f + rand.m_188501_() * 5.0f) : (int)(2.0f + rand.m_188501_() * 4.0f);
    }

    private int getRandomHeight(RandomSource rand, boolean isHuge) {
        int bonus = rand.m_188503_(8) == 0 ? 1 : 0;
        return 2 + (isHuge ? bonus + 1 : bonus);
    }

    private boolean isPosInsideEllipsis(BlockPos pos, float a, float b, float c) {
        float z;
        float y;
        float x = (float)pos.m_123341_() - 0.5f;
        return x * x / (a * a) + (y = (float)pos.m_123342_()) * y / (b * b) + (z = (float)pos.m_123343_() - 0.5f) * z / (c * c) < 1.0f;
    }

    private boolean isCapBlockPos(BlockPos pos, float a, float b, float c) {
        if (this.isPosInsideEllipsis(pos, a, b, c)) {
            return false;
        }
        if (this.isPosInsideEllipsis(pos.m_7495_(), a, b, c)) {
            return true;
        }
        if (this.isPosInsideEllipsis(pos.m_122012_(), a, b, c)) {
            return true;
        }
        if (this.isPosInsideEllipsis(pos.m_122019_(), a, b, c)) {
            return true;
        }
        if (this.isPosInsideEllipsis(pos.m_122024_(), a, b, c)) {
            return true;
        }
        return this.isPosInsideEllipsis(pos.m_122029_(), a, b, c);
    }
}

