/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Util.FeatureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeMushroomFeature
extends Feature<HugeMushroomFeatureConfiguration> {
    public HugeMushroomFeature(Codec<HugeMushroomFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        float yCapFactor;
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        HugeMushroomFeatureConfiguration config = (HugeMushroomFeatureConfiguration)context.m_159778_();
        int stemSize = rand.m_188503_(6) == 0 ? rand.m_188503_(8) + 5 : rand.m_188503_(5) + 8;
        int capRadius = 3 + rand.m_188503_(2);
        float f = yCapFactor = rand.m_188503_(2) == 0 ? 0.5f : 0.6f;
        if (!this.canGrow(config, (LevelAccessor)world, pos, stemSize, capRadius)) {
            return false;
        }
        this.generateCap(config, (LevelAccessor)world, rand, pos, stemSize, yCapFactor, capRadius);
        this.generateStem(config, (LevelAccessor)world, rand, pos, stemSize);
        return true;
    }

    protected void generateCap(HugeMushroomFeatureConfiguration config, LevelAccessor world, RandomSource rand, BlockPos blockPos, int stemSize, float yCapFactor, int capRadius) {
        float c;
        BlockPos.MutableBlockPos placementPos = new BlockPos.MutableBlockPos();
        int capHeight = (int)((float)stemSize * yCapFactor);
        int yCap = (int)((float)stemSize * (1.0f - yCapFactor));
        BlockPos centerPos = blockPos.m_7918_(0, yCap, 0);
        float a = c = (float)capRadius;
        float b = capHeight;
        int bonus = 1;
        for (int y = 0; y <= capHeight + bonus; ++y) {
            for (int x = -capRadius - bonus; x <= capRadius + bonus; ++x) {
                for (int z = -capRadius - bonus; z <= capRadius + bonus; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.isPosInsideEllipsis(pos, a, b, c)) continue;
                    boolean downInEll = this.isPosInsideEllipsis(pos.m_7495_(), a, b, c);
                    boolean northInEll = this.isPosInsideEllipsis(pos.m_122012_(), a, b, c);
                    boolean southInEll = this.isPosInsideEllipsis(pos.m_122019_(), a, b, c);
                    boolean westInEll = this.isPosInsideEllipsis(pos.m_122024_(), a, b, c);
                    boolean eastInEll = this.isPosInsideEllipsis(pos.m_122029_(), a, b, c);
                    if (!downInEll && !northInEll && !southInEll && !westInEll && !eastInEll) continue;
                    boolean isUpCap = this.isCapBlockPos(pos.m_7494_(), a, b, c);
                    placementPos.m_122190_((Vec3i)centerPos.m_121955_((Vec3i)pos));
                    if (!FeatureHelper.isReplaceableByLogOrLeavesFeature(world, (BlockPos)placementPos, true)) continue;
                    this.m_5974_((LevelWriter)world, (BlockPos)placementPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.f_67740_.m_213972_(rand, (BlockPos)placementPos).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(!northInEll))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(!southInEll))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(!westInEll))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(!eastInEll))).m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(!isUpCap)));
                }
            }
        }
    }

    protected void generateStem(HugeMushroomFeatureConfiguration config, LevelAccessor world, RandomSource rand, BlockPos blockPos, int stemSize) {
        BlockPos.MutableBlockPos placementPos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < stemSize; ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    placementPos.m_122190_((Vec3i)blockPos).m_122184_(x, y, z);
                    if (!FeatureHelper.isReplaceableByLogOrLeavesFeature(world, (BlockPos)placementPos, true) && !world.m_8055_((BlockPos)placementPos).m_60713_((Block)AerialHellBlocksAndItems.VERDIGRIS_AGARIC.get())) continue;
                    this.m_5974_((LevelWriter)world, (BlockPos)placementPos, config.f_67741_.m_213972_(rand, blockPos));
                }
            }
        }
    }

    private boolean isPosInsideEllipsis(BlockPos pos, float a, float b, float c) {
        float z;
        float y;
        float x = (float)pos.m_123341_() - 0.5f;
        return x * x / (a * a) + (y = (float)pos.m_123342_()) * y / (b * b) + (z = (float)pos.m_123343_() - 0.5f) * z / (c * c) < 1.0f;
    }

    private boolean isCapBlockPos(BlockPos pos, float a, float b, float c) {
        if (this.isPosInsideEllipsis(pos, a, b, c)) {
            return false;
        }
        if (this.isPosInsideEllipsis(pos.m_7495_(), a, b, c)) {
            return true;
        }
        if (this.isPosInsideEllipsis(pos.m_122012_(), a, b, c)) {
            return true;
        }
        if (this.isPosInsideEllipsis(pos.m_122019_(), a, b, c)) {
            return true;
        }
        if (this.isPosInsideEllipsis(pos.m_122024_(), a, b, c)) {
            return true;
        }
        return this.isPosInsideEllipsis(pos.m_122029_(), a, b, c);
    }

    protected boolean canGrow(HugeMushroomFeatureConfiguration config, LevelAccessor world, BlockPos blockPos, int stemSize, int capRadius) {
        return this.mayPlaceOn(world, blockPos) && this.canPlaceStem(config, world, blockPos, stemSize) && blockPos.m_123342_() >= blockPos.m_123342_() && blockPos.m_123342_() + stemSize + 1 < world.m_141928_();
    }

    protected boolean canPlaceStem(HugeMushroomFeatureConfiguration config, LevelAccessor world, BlockPos blockPos, int stemSize) {
        BlockPos.MutableBlockPos placementBlockPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                for (int y = 0; y <= stemSize; ++y) {
                    placementBlockPos.m_122190_((Vec3i)blockPos).m_122175_(Direction.UP, y);
                    if (FeatureHelper.isReplaceableByLogOrLeavesFeature(world, (BlockPos)placementBlockPos, true)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean mayPlaceOn(LevelAccessor world, BlockPos pos) {
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                BlockState blockState = world.m_8055_(pos.m_7918_(x, -1, z));
                if (blockState.m_204336_(BlockTags.f_13057_)) continue;
                return false;
            }
        }
        return true;
    }
}

