/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.FeatureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class RockFeature
extends Feature<NoneFeatureConfiguration> {
    WeightedStateProvider blockStateProvider;

    public RockFeature(Codec<NoneFeatureConfiguration> codec, WeightedStateProvider bsProvider) {
        super(codec);
        this.blockStateProvider = bsProvider;
    }

    protected BlockState randomState(RandomSource rand, BlockPos pos) {
        return this.blockStateProvider.m_213972_(rand, pos);
    }

    protected void placeBlocks(WorldGenLevel reader, BlockPos pos, BlockState state, int number, Direction direction) {
        for (int d = 0; d < number; ++d) {
            reader.m_7731_(pos.m_5484_(direction, d), state, 2);
        }
    }

    protected boolean canGenerateAtPos(FeaturePlaceContext<NoneFeatureConfiguration> context, BlockPos placementPos) {
        return this.hasSupportToGenerate(context.m_159774_(), placementPos) && !FeatureHelper.isFeatureGeneratingNextToDungeon(context);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        ChunkGenerator generator = context.m_159775_();
        BlockPos placementPos = this.findPosForPlacement(reader, pos);
        if (!this.canGenerateAtPos(context, placementPos)) {
            return false;
        }
        this.placeBlocks(reader, placementPos, this.randomState(rand, placementPos), 3, Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.DOWN), this.randomState(rand, placementPos), 1 + rand.m_188503_(2), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.NORTH), this.randomState(rand, placementPos), 2, Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.NORTH).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(2), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.EAST), this.randomState(rand, placementPos), 2, Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.EAST).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(3), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.SOUTH), this.randomState(rand, placementPos), rand.m_188503_(4) < 3 ? 2 : 1, Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.SOUTH).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(3), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.WEST), this.randomState(rand, placementPos), rand.m_188503_(4) < 3 ? 2 : 1, Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.WEST).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(2), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST), this.randomState(rand, placementPos), rand.m_188503_(2), Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(3), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST), this.randomState(rand, placementPos), rand.m_188503_(2), Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(3), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST), this.randomState(rand, placementPos), rand.m_188503_(2), Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(3), Direction.DOWN);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST), this.randomState(rand, placementPos), rand.m_188503_(2), Direction.UP);
        this.placeBlocks(reader, placementPos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST).m_121945_(Direction.DOWN), this.randomState(rand, placementPos), rand.m_188503_(3), Direction.DOWN);
        return true;
    }

    protected BlockPos findPosForPlacement(WorldGenLevel reader, BlockPos originalPos) {
        int x = originalPos.m_123341_();
        int y = 250;
        int z = originalPos.m_123343_();
        int ymin = 50;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)new BlockPos(x, y, z));
        while (y > ymin) {
            if (this.hasSupportToGenerate(reader, (BlockPos)mutablePos)) {
                return mutablePos;
            }
            mutablePos.m_122190_((Vec3i)new BlockPos(x, --y, z));
        }
        return originalPos;
    }

    private boolean hasSupportToGenerate(WorldGenLevel reader, BlockPos pos) {
        return reader.m_46859_(pos) && reader.m_8055_(pos.m_7495_()).m_204336_(AerialHellTags.Blocks.STELLAR_DIRT);
    }
}

