/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.FeatureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SlipperySandFeature
extends Feature<NoneFeatureConfiguration> {
    public SlipperySandFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        ChunkGenerator generator = context.m_159775_();
        boolean canGenerate = !(!reader.m_8055_(blockPos.m_122013_(3)).m_60734_().equals(Blocks.f_50016_) && !reader.m_8055_(blockPos.m_122020_(3)).m_60734_().equals(Blocks.f_50016_) && !reader.m_8055_(blockPos.m_122025_(3)).m_60734_().equals(Blocks.f_50016_) && !reader.m_8055_(blockPos.m_122030_(3)).m_60734_().equals(Blocks.f_50016_) || !reader.m_8055_(blockPos).m_204336_(AerialHellTags.Blocks.STELLAR_STONE) && reader.m_8055_(blockPos).m_60734_() != AerialHellBlocksAndItems.STELLAR_DIRT.get());
        boolean generatesInDungeon = FeatureHelper.isFeatureGeneratingNextToDungeon(context);
        if (canGenerate && !generatesInDungeon) {
            this.generateSlipperySand(reader, rand, blockPos);
            return true;
        }
        return false;
    }

    protected void generateSlipperySand(WorldGenLevel reader, RandomSource rand, BlockPos blockPos) {
        BlockPos.MutableBlockPos placementPos = new BlockPos.MutableBlockPos();
        boolean isBig = rand.m_188500_() > 0.8;
        int radiusX = this.getRandomRadius(rand, isBig);
        int radiusY = 2;
        int radiusZ = this.getRandomRadius(rand, isBig);
        boolean offsetY = rand.m_188503_(6) == 0;
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = 0; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isPosInsideEllipsis(pos, radiusX, radiusY, radiusZ)) continue;
                    placementPos.m_122190_((Vec3i)blockPos.m_121955_((Vec3i)pos));
                    if (!this.isReplaceable(reader, (BlockPos)placementPos)) continue;
                    boolean isInsideInnerEllipsis = this.isPosInsideEllipsis(pos, radiusX - 1, radiusY, radiusZ - 1);
                    if (isInsideInnerEllipsis) {
                        reader.m_7731_((BlockPos)placementPos, ((Block)AerialHellBlocksAndItems.SLIPPERY_SAND.get()).m_49966_(), 0);
                        continue;
                    }
                    if (rand.m_188503_(3) == 0) continue;
                    reader.m_7731_((BlockPos)placementPos, ((Block)AerialHellBlocksAndItems.SLIPPERY_SAND.get()).m_49966_(), 0);
                }
            }
        }
    }

    private boolean isReplaceable(WorldGenLevel reader, BlockPos blockPos) {
        BlockState previousBlock = reader.m_8055_(blockPos);
        return previousBlock.m_60795_() || previousBlock.m_204336_(AerialHellTags.Blocks.FEATURE_CAN_REPLACE);
    }

    private int getRandomRadius(RandomSource rand, boolean isBig) {
        return isBig ? (int)(5.0f + rand.m_188501_() * 5.0f) : (int)(3.0f + rand.m_188501_() * 4.0f);
    }

    private boolean isPosInsideEllipsis(BlockPos pos, float a, float b, float c) {
        float z;
        float y;
        float x = (float)pos.m_123341_() - 0.5f;
        return x * x / (a * a) + (y = (float)pos.m_123342_()) * y / (b * b) + (z = (float)pos.m_123343_() - 0.5f) * z / (c * c) < 1.0f;
    }
}

