/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Structure;

import fr.factionbedrock.aerialhell.Util.StructureHelper;
import fr.factionbedrock.aerialhell.World.Structure.AbstractAerialHellStructure;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public abstract class AbstractClassicLittleStructure
extends AbstractAerialHellStructure {
    public AbstractClassicLittleStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, List.of());
    }

    @Override
    protected boolean isStructureChunk(Structure.GenerationContext context) {
        if (StructureHelper.hasDungeonNearby(context, 150, true, 100)) {
            return false;
        }
        int landHeight = AbstractClassicLittleStructure.getTerrainHeight(context);
        return landHeight > this.getMinY() && landHeight < this.getMaxY();
    }

    protected abstract int getMinY();

    protected abstract int getMaxY();
}

