/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellStructures;
import fr.factionbedrock.aerialhell.Util.StructureHelper;
import fr.factionbedrock.aerialhell.World.Structure.AbstractAerialHellStructure;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class LunaticTempleStructure
extends AbstractAerialHellStructure {
    public static final Codec<LunaticTempleStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LunaticTempleStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)50).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, LunaticTempleStructure::new)).codec();

    public LunaticTempleStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, List.of());
    }

    @Override
    protected boolean isStructureChunk(Structure.GenerationContext context) {
        ChunkGenerator chunkGenerator = context.f_226622_();
        ChunkPos chunkpos = context.f_226628_();
        LevelHeightAccessor level = context.f_226629_();
        long seed = context.f_226627_();
        BlockPos centerOfChunk = chunkpos.m_151394_(0);
        return !StructureHelper.hasGoldenNetherPrisonNearby(chunkGenerator, seed, chunkpos.f_45578_, chunkpos.f_45579_, 6, true);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AerialHellStructures.LUNATIC_TEMPLE_STRUCTURE.get();
    }
}

