/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnEntityPacket {
    private static final ResourceLocation PACKET_ID = new ResourceLocation("architectury", "spawn_entity_packet");

    public static Packet<ClientGamePacketListener> create(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130130_(BuiltInRegistries.f_256780_.m_7447_((Object)entity.m_6095_()));
        buffer.m_130077_(entity.m_20148_());
        buffer.m_130130_(entity.m_19879_());
        Vec3 position = entity.m_20182_();
        buffer.writeDouble(position.f_82479_);
        buffer.writeDouble(position.f_82480_);
        buffer.writeDouble(position.f_82481_);
        buffer.writeFloat(entity.m_146909_());
        buffer.writeFloat(entity.m_146908_());
        buffer.writeFloat(entity.m_6080_());
        Vec3 deltaMovement = entity.m_20184_();
        buffer.writeDouble(deltaMovement.f_82479_);
        buffer.writeDouble(deltaMovement.f_82480_);
        buffer.writeDouble(deltaMovement.f_82481_);
        if (entity instanceof EntitySpawnExtension) {
            EntitySpawnExtension ext = (EntitySpawnExtension)entity;
            ext.saveAdditionalSpawnData(buffer);
        }
        return NetworkManager.toPacket(NetworkManager.s2c(), PACKET_ID, buffer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        @OnlyIn(value=Dist.CLIENT)
        public static void register() {
            NetworkManager.registerReceiver(NetworkManager.s2c(), PACKET_ID, Client::receive);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void receive(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
            int entityTypeId = buf.m_130242_();
            UUID uuid = buf.m_130259_();
            int id = buf.m_130242_();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xRot = buf.readFloat();
            float yRot = buf.readFloat();
            float yHeadRot = buf.readFloat();
            double deltaX = buf.readDouble();
            double deltaY = buf.readDouble();
            double deltaZ = buf.readDouble();
            buf.retain();
            context.queue(() -> {
                EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7942_(entityTypeId);
                if (entityType == null) {
                    throw new IllegalStateException("Entity type (" + entityTypeId + ") is unknown, spawning at (" + x + ", " + y + ", " + z + ")");
                }
                if (Minecraft.m_91087_().f_91073_ == null) {
                    throw new IllegalStateException("Client world is null!");
                }
                Entity entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
                if (entity == null) {
                    throw new IllegalStateException("Created entity is null!");
                }
                entity.m_20084_(uuid);
                entity.m_20234_(id);
                entity.m_217006_(x, y, z);
                entity.m_6027_(x, y, z);
                entity.m_146926_(xRot);
                entity.m_146922_(yRot);
                entity.m_5616_(yHeadRot);
                entity.m_5618_(yHeadRot);
                if (entity instanceof EntitySpawnExtension) {
                    EntitySpawnExtension ext = (EntitySpawnExtension)entity;
                    ext.loadAdditionalSpawnData(buf);
                }
                buf.release();
                Minecraft.m_91087_().f_91073_.m_104739_(entity);
                entity.m_6001_(deltaX, deltaY, deltaZ);
            });
        }
    }
}

