/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.mixin;

import com.google.common.base.Objects;
import fuzs.blockrunner.world.level.block.data.BlockSpeedManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private BlockPos f_20956_;

    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getBlockSpeedFactor(CallbackInfoReturnable<Float> callback) {
        if (BlockSpeedManager.INSTANCE.hasBlockSpeed(this.m_9236_().m_8055_(this.m_20099_()).m_60734_())) {
            callback.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    protected void onChangedBlock(BlockPos pos, CallbackInfo callback) {
        this.blockrunner$onChangedBlock();
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo callback) {
        if ((!this.m_9236_().f_46443_ || LivingEntity.class.cast((Object)this) instanceof Player) && onGround && this.f_19789_ > 0.0f) {
            this.blockrunner$removeBlockSpeed();
            this.blockrunner$tryAddBlockSpeed();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo callback) {
        BlockPos blockPos;
        if (this.m_9236_().f_46443_ && LivingEntity.class.cast((Object)this) instanceof Player && !Objects.equal((Object)this.f_20956_, (Object)(blockPos = this.m_20183_()))) {
            this.f_20956_ = blockPos;
            this.blockrunner$onChangedBlock();
        }
    }

    @Unique
    private void blockrunner$onChangedBlock() {
        if (this.m_6757_(this.m_20075_())) {
            this.blockrunner$removeBlockSpeed();
        }
        this.blockrunner$tryAddBlockSpeed();
    }

    @Unique
    private void blockrunner$removeBlockSpeed() {
        AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
        if (attribute != null && attribute.m_22111_(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID) != null) {
            attribute.m_22120_(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
        }
    }

    @Unique
    protected void blockrunner$tryAddBlockSpeed() {
        block6: {
            BlockState blockStateOn;
            block5: {
                Object t = LivingEntity.class.cast((Object)this);
                if (!(t instanceof Player)) break block5;
                Player player = (Player)t;
                if (player.m_150110_().f_35935_) break block6;
            }
            if (!(blockStateOn = this.m_20075_()).m_60795_()) {
                double speedFactor = BlockSpeedManager.INSTANCE.getSpeedFactor(blockStateOn.m_60734_());
                AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
                if (attribute == null || speedFactor == 1.0) {
                    return;
                }
                double baseValue = attribute.m_22115_();
                speedFactor = speedFactor * baseValue - baseValue;
                attribute.m_22118_(new AttributeModifier(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID, "Block speed boost", speedFactor, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Shadow
    public abstract AttributeInstance m_21051_(Attribute var1);

    @Shadow
    protected abstract boolean m_6757_(BlockState var1);
}

