/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.check.RegisterMod;
import com.natamus.collective_common_neoforge.config.CollectiveConfigHandler;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.SpawnEntityFunctions;
import com.natamus.collective_common_neoforge.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CollectiveEvents {
    public static WeakHashMap<ServerLevel, List<Entity>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<ServerLevel, WeakHashMap<Entity, Entity>> entitiesToRide = new WeakHashMap();
    public static CopyOnWriteArrayList<Pair<Integer, Runnable>> scheduledRunnables = new CopyOnWriteArrayList();

    public static void onWorldTick(ServerLevel serverLevel) {
        if (entitiesToSpawn.computeIfAbsent(serverLevel, k -> new ArrayList()).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverLevel).get(0);
            serverLevel.addFreshEntityWithPassengers(tospawn);
            if (entitiesToRide.computeIfAbsent(serverLevel, k -> new WeakHashMap()).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(serverLevel).get(tospawn);
                rider.startRiding(tospawn);
                entitiesToRide.get(serverLevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverLevel).remove(0);
        }
    }

    public static void onServerTick(MinecraftServer minecraftServer) {
        int serverTickCount = minecraftServer.getTickCount();
        for (Pair<Integer, Runnable> pair : scheduledRunnables) {
            if ((Integer)pair.getFirst() > serverTickCount) continue;
            minecraftServer.tell((Runnable)new TickTask(minecraftServer.getTickCount(), (Runnable)pair.getSecond()));
            scheduledRunnables.remove(pair);
        }
    }

    public static boolean onEntityJoinLevel(Level level, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof Player) {
            RegisterMod.joinWorldProcess(level, (Player)entity);
        }
        if (entity.isRemoved()) {
            return true;
        }
        if (GlobalVariables.globalSAMs.isEmpty()) {
            return true;
        }
        Set tags = entity.getTags();
        if (tags.contains("collective.checked")) {
            return true;
        }
        entity.addTag("collective.checked");
        EntityType entityType = entity.getType();
        if (!GlobalVariables.activeSAMEntityTypes.contains(entityType)) {
            return true;
        }
        boolean isFromSpawner = tags.contains("collective.fromspawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject sam : GlobalVariables.globalSAMs) {
            if (sam == null || sam.fromEntityType == null || !sam.fromEntityType.equals((Object)entityType) || sam.onlyFromSpawner && !isFromSpawner || !sam.onlyFromSpawner && isFromSpawner) continue;
            possibles.add(sam);
        }
        int size = possibles.size();
        if (size == 0) {
            return true;
        }
        boolean ageable = entity instanceof AgeableMob;
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.changeChance) continue;
            Vec3 eVec = entity.position();
            boolean isOnSurface = BlockPosFunctions.isOnSurface(level, eVec);
            if (!sam.onlyOnSurface ? sam.onlyBelowSurface && isOnSurface : !isOnSurface) continue;
            Entity to = sam.toEntityType.create(level);
            if (to == null) {
                return true;
            }
            to.setPos(eVec.x, eVec.y, eVec.z);
            if (ageable && to instanceof AgeableMob) {
                AgeableMob am = (AgeableMob)to;
                am.setAge(((AgeableMob)entity).getAge());
                to = am;
            }
            boolean ignoreMainhand = false;
            if (sam.itemToHold != null && to instanceof LivingEntity && !(le = (LivingEntity)to).getMainHandItem().getItem().equals(sam.itemToHold)) {
                le.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)sam.itemToHold, 1));
                ignoreMainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideNotReplace) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.setTamed(true);
                ride = true;
            } else if (CollectiveConfigHandler.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoreMainhand);
            }
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverLevel, to, entity);
            } else {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            to.addTag("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverLevel, to);
            return ride;
        }
        return true;
    }
}

