/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.natamus.collective_common_neoforge.data.GlobalVariables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockFunctions {
    public static Boolean isSpecificBlock(Block specificblock, Block tocheckblock) {
        if (specificblock == null || tocheckblock == null) {
            return false;
        }
        return specificblock.equals(tocheckblock);
    }

    public static Boolean isSpecificBlock(Block specificblock, ItemStack tocheckitemstack) {
        if (tocheckitemstack == null) {
            return false;
        }
        Item tocheckitem = tocheckitemstack.getItem();
        if (tocheckitem == null) {
            return false;
        }
        Block tocheckblock = Block.byItem((Item)tocheckitem);
        return BlockFunctions.isSpecificBlock(specificblock, tocheckblock);
    }

    public static Boolean isSpecificBlock(Block specificblock, Level world, BlockPos pos) {
        Block tocheckblock = world.getBlockState(pos).getBlock();
        return BlockFunctions.isSpecificBlock(specificblock, tocheckblock);
    }

    public static void dropBlock(Level world, BlockPos pos) {
        BlockState blockstate = world.getBlockState(pos);
        BlockEntity tileentity = world.getBlockEntity(pos);
        Block.dropResources((BlockState)blockstate, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tileentity);
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    public static Boolean isOneOfBlocks(List<Block> blocks, Block tocheckblock) {
        if (blocks.size() < 1) {
            return false;
        }
        for (Block specificblock : blocks) {
            if (!BlockFunctions.isSpecificBlock(specificblock, tocheckblock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Boolean isOneOfBlocks(List<Block> blocks, ItemStack tocheckitemstack) {
        if (tocheckitemstack == null) {
            return false;
        }
        Item tocheckitem = tocheckitemstack.getItem();
        if (tocheckitem == null) {
            return false;
        }
        Block tocheckblock = Block.byItem((Item)tocheckitem);
        return BlockFunctions.isOneOfBlocks(blocks, tocheckblock);
    }

    public static Boolean isOneOfBlocks(List<Block> blocks, Level world, BlockPos pos) {
        Block tocheckblock = world.getBlockState(pos).getBlock();
        return BlockFunctions.isOneOfBlocks(blocks, tocheckblock);
    }

    public static boolean isGrowBlock(Block block) {
        return GlobalVariables.growblocks.contains(block);
    }

    public static boolean isStoneTypeBlock(Block block) {
        return GlobalVariables.stoneblocks.contains(block);
    }

    public static Boolean isFilledPortalFrame(BlockState blockstate) {
        Block block = blockstate.getBlock();
        if (!block.equals(Blocks.END_PORTAL_FRAME)) {
            return false;
        }
        return (Boolean)blockstate.getValue((Property)EndPortalFrameBlock.HAS_EYE);
    }

    public static String blockToReadableString(Block block, int amount) {
        String[] blockspl = block.getDescriptionId().replace("block.", "").split("\\.");
        Object blockstring = blockspl.length > 1 ? blockspl[1] : blockspl[0];
        blockstring = ((String)blockstring).replace("_", " ");
        if (amount > 1) {
            blockstring = (String)blockstring + "s";
        }
        return blockstring;
    }

    public static String blockToReadableString(Block block) {
        return BlockFunctions.blockToReadableString(block, 1);
    }
}

