/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerFunctions {
    public static boolean respawnPlayer(Level world, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        MinecraftServer server = world.getServer();
        ServerPlayer serverplayer = (ServerPlayer)player;
        if (serverplayer.wonGame) {
            serverplayer.wonGame = false;
            serverplayer = server.getPlayerList().respawn(serverplayer, true);
            CriteriaTriggers.CHANGED_DIMENSION.trigger(serverplayer, Level.END, Level.OVERWORLD);
        } else if (serverplayer.getHealth() <= 0.0f) {
            server.getPlayerList().respawn(serverplayer, false);
        }
        return true;
    }

    public static Player matchPlayer(Player player, String other) {
        return PlayerFunctions.matchPlayer(player.level(), other);
    }

    public static Player matchPlayer(Level world, String other) {
        List players = world.players();
        for (Player onlineplayer : players) {
            if (!onlineplayer.getName().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(Player player) {
        return player.getItemInHand(InteractionHand.OFF_HAND).getItem().equals(Items.WATER_BUCKET) || player.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(Items.WATER_BUCKET);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, true);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory) {
        String firstjointag = "collective.firstJoin." + modid;
        Set tags = player.getTags();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.addTag(firstjointag);
        if (mustHaveEmptyInventory) {
            Inventory inv = player.getInventory();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                if (inv.getItem(i).isEmpty()) continue;
                isempty = false;
                break;
            }
            if (!isempty) {
                return false;
            }
        }
        Level level = player.getCommandSenderWorld();
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos wspos = serverLevel.getSharedSpawnPos();
        BlockPos ppos = player.blockPosition();
        BlockPos cpos = new BlockPos(ppos.getX(), wspos.getY(), ppos.getZ());
        int spawnRadius = ((GameRules.IntegerValue)serverLevel.getGameRules().getRule(GameRules.RULE_SPAWN_RADIUS)).get();
        return cpos.closerThan((Vec3i)wspos, (double)(spawnRadius * 2));
    }

    public static BlockPos getSpawnPoint(Level world, Player player) {
        Vec3 spawnvec = PlayerFunctions.getSpawnVec(world, player);
        return BlockPos.containing((double)spawnvec.x, (double)spawnvec.y, (double)spawnvec.z);
    }

    public static Vec3 getSpawnVec(Level world, Player player) {
        Optional optionalbed;
        ServerPlayer serverplayer = (ServerPlayer)player;
        ServerLevel ServerLevel2 = (ServerLevel)world;
        BlockPos respawnlocation = ServerLevel2.getSharedSpawnPos();
        Vec3 respawnvec = new Vec3((double)respawnlocation.getX(), (double)respawnlocation.getY(), (double)respawnlocation.getZ());
        BlockPos bedpos = serverplayer.getRespawnPosition();
        if (bedpos != null && (optionalbed = Player.findRespawnPositionAndUseSpawnBlock((ServerLevel)ServerLevel2, (BlockPos)bedpos, (float)1.0f, (boolean)false, (boolean)false)).isPresent()) {
            Vec3 bedvec = (Vec3)optionalbed.get();
            BlockPos bp = BlockPos.containing((Position)bedvec);
            Iterator it = BlockPos.betweenClosedStream((int)(bp.getX() - 1), (int)(bp.getY() - 1), (int)(bp.getZ() - 1), (int)(bp.getX() + 1), (int)(bp.getY() + 1), (int)(bp.getZ() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                BlockState state = world.getBlockState(np);
                Block block = state.getBlock();
                if (!(block instanceof BedBlock)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static InteractionHand getOtherHand(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    public static String getPlayerGearString(Player player) {
        StringBuilder skconfig = new StringBuilder();
        ItemStack offhand = player.getItemBySlot(EquipmentSlot.OFFHAND);
        if (!offhand.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(offhand);
            skconfig.append("'offhand' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("'offhand' : '',");
        }
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!head.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(head);
            skconfig.append("\n'head' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'head' : '',");
        }
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!chest.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(chest);
            skconfig.append("\n'chest' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'chest' : '',");
        }
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        if (!legs.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(legs);
            skconfig.append("\n'legs' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'legs' : '',");
        }
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        if (!feet.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(feet);
            skconfig.append("\n'feet' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'feet' : '',");
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.getItem(i);
            if (!slot.isEmpty()) {
                String nbtstring = ItemFunctions.getNBTStringFromItemStack(slot);
                skconfig.append("\n").append(i).append(" : ").append("'").append(nbtstring).append("',");
                continue;
            }
            skconfig.append("\n").append(i).append(" : '',");
        }
        return skconfig.toString();
    }

    public static String getPlayerGearStringFromHashMap(HashMap<String, ItemStack> gear) {
        StringBuilder gearstring = new StringBuilder();
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                specialslotstring = ItemFunctions.getNBTStringFromItemStack(gear.get(specialslot));
            }
            if (!gearstring.toString().equals("")) {
                gearstring.append("\n");
            }
            gearstring.append("'").append(specialslot).append("'").append(" : ").append("'").append(specialslotstring).append("',");
        }
        NonNullList emptyinventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                itemstring = ItemFunctions.getNBTStringFromItemStack(gear.get("" + i));
            }
            gearstring.append("\n").append(i).append(" : '").append(itemstring).append("',");
        }
        return gearstring.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void setPlayerGearFromString(Player player, String gearconfig) {
        String[] gearspl = gearconfig.split("',[\\r\\n]+");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        block18: for (String string : gearspl) {
            EquipmentSlot type;
            void var8_8;
            String[] lspl;
            void var8_12;
            String string2 = string.trim();
            if (string2.endsWith(",")) {
                String string3 = string2.substring(0, string2.length() - 1);
            }
            if (!var8_12.endsWith("'")) {
                String string4 = (String)var8_12 + "'";
            }
            if ((lspl = var8_8.split(" : ")).length != 2) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The line " + (String)var8_8 + " is invalid.");
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if (data.startsWith("'")) {
                data = data.substring(1);
            }
            if (data.endsWith("'")) {
                data = data.substring(0, data.length() - 1);
            }
            if (data.length() < 2) continue;
            data = data.replaceAll("\r", "");
            ItemStack itemstack = null;
            try {
                CompoundTag newnbt = TagParser.parseTag((String)data);
                itemstack = ItemStack.of((CompoundTag)newnbt);
            }
            catch (CommandSyntaxException e0) {
                try {
                    data = data.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
                    CompoundTag newnbt = TagParser.parseTag((String)data);
                    itemstack = ItemStack.of((CompoundTag)newnbt);
                }
                catch (CommandSyntaxException e1) {
                    e1.printStackTrace();
                }
            }
            if (itemstack == null) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: Unable to get the correct itemstack data from data " + data);
                return;
            }
            if (!cleared) {
                cleared = true;
                player.getInventory().clearContent();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.getInventory().setItem(slot, itemstack);
                continue;
            }
            switch (slotstring) {
                case "offhand": {
                    type = EquipmentSlot.OFFHAND;
                    break;
                }
                case "head": {
                    type = EquipmentSlot.HEAD;
                    break;
                }
                case "chest": {
                    type = EquipmentSlot.CHEST;
                    break;
                }
                case "legs": {
                    type = EquipmentSlot.LEGS;
                    break;
                }
                case "feet": {
                    type = EquipmentSlot.FEET;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            player.setItemSlot(type, itemstack);
        }
    }
}

